/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.support;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.netflix.ribbon.support.ResettableServletInputStreamWrapper;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;

public class RibbonCommandContext {
    private final String serviceId;
    private final String method;
    private final String uri;
    private final Boolean retryable;
    private final MultiValueMap<String, String> headers;
    private final MultiValueMap<String, String> params;
    private final List<RibbonRequestCustomizer> requestCustomizers;
    private InputStream requestEntity;
    private Long contentLength;
    private Object loadBalancerKey;

    @Deprecated
    public RibbonCommandContext(String serviceId, String method, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) {
        this(serviceId, method, uri, retryable, headers, params, requestEntity, new ArrayList<RibbonRequestCustomizer>(), null, null);
    }

    public RibbonCommandContext(String serviceId, String method, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity, List<RibbonRequestCustomizer> requestCustomizers) {
        this(serviceId, method, uri, retryable, headers, params, requestEntity, requestCustomizers, null, null);
    }

    public RibbonCommandContext(String serviceId, String method, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity, List<RibbonRequestCustomizer> requestCustomizers, Long contentLength) {
        this(serviceId, method, uri, retryable, headers, params, requestEntity, requestCustomizers, contentLength, null);
    }

    public RibbonCommandContext(String serviceId, String method, String uri, Boolean retryable, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity, List<RibbonRequestCustomizer> requestCustomizers, Long contentLength, Object loadBalancerKey) {
        Assert.notNull((Object)serviceId, (String)"serviceId may not be null");
        Assert.notNull((Object)method, (String)"method may not be null");
        Assert.notNull((Object)uri, (String)"uri may not be null");
        Assert.notNull(headers, (String)"headers may not be null");
        Assert.notNull(params, (String)"params may not be null");
        Assert.notNull(requestCustomizers, (String)"requestCustomizers may not be null");
        this.serviceId = serviceId;
        this.method = method;
        this.uri = uri;
        this.retryable = retryable;
        this.headers = headers;
        this.params = params;
        this.requestEntity = requestEntity;
        this.requestCustomizers = requestCustomizers;
        this.contentLength = contentLength;
        this.loadBalancerKey = loadBalancerKey;
    }

    public URI uri() {
        try {
            return new URI(this.uri);
        }
        catch (URISyntaxException e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public String getVerb() {
        return this.method;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getParams() {
        return this.params;
    }

    public InputStream getRequestEntity() {
        if (this.requestEntity == null) {
            return null;
        }
        try {
            if (!(this.requestEntity instanceof ResettableServletInputStreamWrapper)) {
                this.requestEntity = new ResettableServletInputStreamWrapper(StreamUtils.copyToByteArray((InputStream)this.requestEntity));
            }
            this.requestEntity.reset();
        }
        finally {
            return this.requestEntity;
        }
    }

    public List<RibbonRequestCustomizer> getRequestCustomizers() {
        return this.requestCustomizers;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Object getLoadBalancerKey() {
        return this.loadBalancerKey;
    }

    public void setLoadBalancerKey(Object loadBalancerKey) {
        this.loadBalancerKey = loadBalancerKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RibbonCommandContext that = (RibbonCommandContext)o;
        return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.method, that.method) && Objects.equals(this.uri, that.uri) && Objects.equals(this.retryable, that.retryable) && Objects.equals(this.headers, that.headers) && Objects.equals(this.params, that.params) && Objects.equals(this.requestEntity, that.requestEntity) && Objects.equals(this.requestCustomizers, that.requestCustomizers) && Objects.equals(this.contentLength, that.contentLength) && Objects.equals(this.loadBalancerKey, that.loadBalancerKey);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.method, this.uri, this.retryable, this.headers, this.params, this.requestEntity, this.requestCustomizers, this.contentLength, this.loadBalancerKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RibbonCommandContext{");
        sb.append("serviceId='").append(this.serviceId).append('\'');
        sb.append(", method='").append(this.method).append('\'');
        sb.append(", uri='").append(this.uri).append('\'');
        sb.append(", retryable=").append(this.retryable);
        sb.append(", headers=").append(this.headers);
        sb.append(", params=").append(this.params);
        sb.append(", requestEntity=").append(this.requestEntity);
        sb.append(", requestCustomizers=").append(this.requestCustomizers);
        sb.append(", contentLength=").append(this.contentLength);
        sb.append(", loadBalancerKey=").append(this.loadBalancerKey);
        sb.append('}');
        return sb.toString();
    }
}

