/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix.dashboard;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.netflix.hystrix.dashboard.HystrixDashboardController;
import org.springframework.cloud.netflix.hystrix.dashboard.HystrixDashboardProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableConfigurationProperties(value={HystrixDashboardProperties.class})
public class HystrixDashboardConfiguration {
    private static final String DEFAULT_TEMPLATE_LOADER_PATH = "classpath:/templates/";
    private static final String DEFAULT_CHARSET = "UTF-8";
    @Autowired
    private HystrixDashboardProperties dashboardProperties;

    @Bean
    public HasFeatures hystrixDashboardFeature() {
        return HasFeatures.namedFeature((String)"Hystrix Dashboard", HystrixDashboardConfiguration.class);
    }

    @Bean
    public FreeMarkerConfigurer freeMarkerConfigurer() {
        FreeMarkerConfigurer configurer = new FreeMarkerConfigurer();
        configurer.setTemplateLoaderPaths(new String[]{DEFAULT_TEMPLATE_LOADER_PATH});
        configurer.setDefaultEncoding(DEFAULT_CHARSET);
        configurer.setPreferFileSystemAccess(false);
        return configurer;
    }

    @Bean
    public ServletRegistrationBean proxyStreamServlet() {
        ProxyStreamServlet proxyStreamServlet = new ProxyStreamServlet();
        proxyStreamServlet.setEnableIgnoreConnectionCloseHeader(this.dashboardProperties.isEnableIgnoreConnectionCloseHeader());
        return new ServletRegistrationBean((Servlet)proxyStreamServlet, new String[]{"/proxy.stream"});
    }

    @Bean
    public HystrixDashboardController hsytrixDashboardController() {
        return new HystrixDashboardController();
    }

    public static class ProxyStreamServlet
    extends HttpServlet {
        private static final Log log = LogFactory.getLog(ProxyStreamServlet.class);
        private static final long serialVersionUID = 1L;
        private static final String CONNECTION_CLOSE_VALUE = "close";
        private boolean enableIgnoreConnectionCloseHeader = false;

        public void setEnableIgnoreConnectionCloseHeader(boolean enableIgnoreConnectionCloseHeader) {
            this.enableIgnoreConnectionCloseHeader = enableIgnoreConnectionCloseHeader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            block30: {
                String origin = request.getParameter("origin");
                if (origin == null) {
                    response.setStatus(500);
                    response.getWriter().println("Required parameter 'origin' missing. Example: 107.20.175.135:7001");
                    return;
                }
                origin = origin.trim();
                HttpGet httpget = null;
                InputStream is = null;
                boolean hasFirstParameter = false;
                StringBuilder url = new StringBuilder();
                if (!origin.startsWith("http")) {
                    url.append("http://");
                }
                url.append(origin);
                if (origin.contains("?")) {
                    hasFirstParameter = true;
                }
                Map params = request.getParameterMap();
                for (String key : params.keySet()) {
                    if (key.equals("origin")) continue;
                    String[] values = (String[])params.get(key);
                    String value = values[0].trim();
                    if (hasFirstParameter) {
                        url.append("&");
                    } else {
                        url.append("?");
                        hasFirstParameter = true;
                    }
                    url.append(key).append("=").append(value);
                }
                String proxyUrl = url.toString();
                log.info((Object)("\n\nProxy opening connection to: " + proxyUrl + "\n\n"));
                try {
                    httpget = new HttpGet(proxyUrl);
                    HttpClient client = ProxyConnectionManager.httpClient;
                    HttpResponse httpResponse = client.execute((HttpUriRequest)httpget);
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        is = httpResponse.getEntity().getContent();
                        this.copyHeadersToServletResponse(httpResponse.getAllHeaders(), response);
                        ServletOutputStream os = response.getOutputStream();
                        int b = -1;
                        while ((b = is.read()) != -1) {
                            try {
                                os.write(b);
                                if (b != 10) continue;
                                os.flush();
                            }
                            catch (Exception ex) {
                                if (ex.getClass().getSimpleName().equalsIgnoreCase("ClientAbortException")) {
                                    log.debug((Object)"Connection closed by client. Will stop proxying ...");
                                    break block30;
                                }
                                throw new RuntimeException(ex);
                            }
                        }
                        break block30;
                    }
                    log.warn((Object)("Failed opening connection to " + proxyUrl + " : " + statusCode + " : " + httpResponse.getStatusLine()));
                }
                catch (Exception ex) {
                    log.error((Object)("Error proxying request: " + url), (Throwable)ex);
                }
                finally {
                    if (httpget != null) {
                        try {
                            httpget.abort();
                        }
                        catch (Exception ex) {
                            log.error((Object)"failed aborting proxy connection.", (Throwable)ex);
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        private void copyHeadersToServletResponse(Header[] headers, HttpServletResponse response) {
            for (Header header : headers) {
                if (this.enableIgnoreConnectionCloseHeader && "Connection".equalsIgnoreCase(header.getName()) && CONNECTION_CLOSE_VALUE.equalsIgnoreCase(header.getValue())) {
                    log.warn((Object)"Ignoring 'Connection: close' header from stream response");
                    continue;
                }
                if ("Transfer-Encoding".equalsIgnoreCase(header.getName())) continue;
                response.addHeader(header.getName(), header.getValue());
            }
        }

        private static class ProxyConnectionManager {
            private static final PoolingClientConnectionManager threadSafeConnectionManager = new PoolingClientConnectionManager();
            private static final HttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeConnectionManager);

            private ProxyConnectionManager() {
            }

            static {
                log.debug((Object)"Initialize ProxyConnectionManager");
                HttpParams httpParams = httpClient.getParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
                HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)10000);
                threadSafeConnectionManager.setDefaultMaxPerRoute(400);
                threadSafeConnectionManager.setMaxTotal(400);
            }
        }
    }
}

