/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import java.util.Set;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.codec.autoconfigure.CodecsAutoConfiguration;
import org.springframework.boot.webclient.autoconfigure.WebClientAutoConfiguration;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.TimeoutProperties;
import org.springframework.cloud.netflix.eureka.config.EurekaConfigServerInstanceProvider;
import org.springframework.cloud.netflix.eureka.config.HostnameBasedUrlRandomizer;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestClientEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.RestClientTransportClientFactory;
import org.springframework.cloud.netflix.eureka.http.WebClientEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.WebClientTransportClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@ConditionalOnClass(value={ConfigServicePropertySourceLocator.class})
@Conditional(value={EurekaConfigServerBootstrapCondition.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TimeoutProperties.class})
public class EurekaConfigServerBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={EurekaClientConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaClientConfigBean eurekaClientConfigBean() {
        return new EurekaClientConfigBean();
    }

    @Bean
    public ConfigServerInstanceProvider.Function eurekaConfigServerInstanceProvider(EurekaHttpClient client, EurekaClientConfig config) {
        return new EurekaConfigServerInstanceProvider(client, config)::getInstances;
    }

    static class EurekaConfigServerBootstrapCondition
    extends AllNestedConditions {
        EurekaConfigServerBootstrapCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
        static class OnEurekaClient {
            OnEurekaClient() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"})
        static class OnCloudConfigProperty {
            OnCloudConfigProperty() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnRestClientPresentAndEnabledCondition.class})
    static class RestClientConfiguration {
        RestClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={EurekaHttpClient.class})
        public RestClientEurekaHttpClient configDiscoveryRestClientEurekaHttpClient(EurekaClientConfigBean config, @Nullable TlsProperties properties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, ObjectProvider<RestClient.Builder> restClientBuilderProvider, Environment env) {
            return (RestClientEurekaHttpClient)new RestClientTransportClientFactory(properties, eurekaClientHttpRequestFactorySupplier, () -> (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).newClient((EurekaEndpoint)HostnameBasedUrlRandomizer.randomEndpoint((EurekaClientConfig)config, env));
        }

        @Bean
        @ConditionalOnMissingBean
        EurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier(TimeoutProperties timeoutProperties, Set<EurekaClientHttpRequestFactorySupplier.RequestConfigCustomizer> requestConfigCustomizers) {
            return new DefaultEurekaClientHttpRequestFactorySupplier(timeoutProperties, requestConfigCustomizers);
        }

        static class OnRestClientPresentAndEnabledCondition
        extends AllNestedConditions {
            OnRestClientPresentAndEnabledCondition() {
                super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
            }

            @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, matchIfMissing=true, havingValue="false")
            static class OnWebClientDisabled {
                OnWebClientDisabled() {
                }
            }

            @ConditionalOnClass(name={"org.springframework.web.client.RestClient"})
            static class OnRestClientPresentCondition {
                OnRestClientPresentCondition() {
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class, WebClientAutoConfiguration.class, CodecsAutoConfiguration.class})
    @ConditionalOnProperty(prefix="eureka.client", name={"webclient.enabled"}, havingValue="true")
    @ImportAutoConfiguration(value={CodecsAutoConfiguration.class, WebClientAutoConfiguration.class})
    protected static class WebClientConfiguration {
        protected WebClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={EurekaHttpClient.class})
        public WebClientEurekaHttpClient configDiscoveryWebClientEurekaHttpClient(EurekaClientConfigBean config, ObjectProvider<WebClient.Builder> builder, Environment env) {
            return (WebClientEurekaHttpClient)new WebClientTransportClientFactory(() -> builder.getIfAvailable()).newClient((EurekaEndpoint)HostnameBasedUrlRandomizer.randomEndpoint((EurekaClientConfig)config, env));
        }
    }
}

