/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaHttpClientUtils;
import org.springframework.cloud.netflix.eureka.http.NotFoundHttpResponse;
import org.springframework.cloud.netflix.eureka.http.RestTemplateEurekaHttpClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Deprecated(forRemoval=true)
public class RestTemplateTransportClientFactory
implements TransportClientFactory {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostnameVerifier> hostnameVerifier;
    private final EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier;
    private final Supplier<RestTemplateBuilder> restTemplateBuilderSupplier;

    public RestTemplateTransportClientFactory(Optional<SSLContext> sslContext, Optional<HostnameVerifier> hostnameVerifier, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, Supplier<RestTemplateBuilder> restTemplateBuilderSupplier) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.eurekaClientHttpRequestFactorySupplier = eurekaClientHttpRequestFactorySupplier;
        this.restTemplateBuilderSupplier = restTemplateBuilderSupplier;
    }

    public RestTemplateTransportClientFactory(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier, Supplier<RestTemplateBuilder> restTemplateBuilderSupplier) {
        this(EurekaHttpClientUtils.context(tlsProperties), Optional.empty(), eurekaClientHttpRequestFactorySupplier, restTemplateBuilderSupplier);
    }

    public RestTemplateTransportClientFactory(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier) {
        this(tlsProperties, eurekaClientHttpRequestFactorySupplier, () -> new RestTemplateBuilder(new RestTemplateCustomizer[0]));
    }

    public RestTemplateTransportClientFactory(Optional<SSLContext> sslContext, Optional<HostnameVerifier> hostnameVerifier, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier) {
        this(sslContext, hostnameVerifier, eurekaClientHttpRequestFactorySupplier, () -> new RestTemplateBuilder(new RestTemplateCustomizer[0]));
    }

    @Deprecated(forRemoval=true)
    public RestTemplateTransportClientFactory() {
        this(Optional.empty(), Optional.empty(), new DefaultEurekaClientHttpRequestFactorySupplier());
    }

    public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
        return new RestTemplateEurekaHttpClient(this.restTemplate(serviceUrl.getServiceUrl()), this.stripUserInfo(serviceUrl.getServiceUrl()));
    }

    private String stripUserInfo(String serviceUrl) {
        return UriComponentsBuilder.fromUriString((String)serviceUrl).userInfo(null).toUriString();
    }

    private RestTemplate restTemplate(String serviceUrl) {
        RestTemplate restTemplate;
        ClientHttpRequestFactory requestFactory = this.eurekaClientHttpRequestFactorySupplier.get(this.sslContext.orElse(null), this.hostnameVerifier.orElse(null));
        if (this.restTemplateBuilderSupplier != null && this.restTemplateBuilderSupplier.get() != null) {
            restTemplate = this.restTemplateBuilderSupplier.get().build();
            restTemplate.setRequestFactory(requestFactory);
        } else {
            restTemplate = new RestTemplate(requestFactory);
        }
        EurekaHttpClientUtils.UserInfo userInfo = EurekaHttpClientUtils.extractUserInfo(serviceUrl);
        if (userInfo != null) {
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(userInfo.username(), userInfo.password()));
        }
        restTemplate.getMessageConverters().add(0, EurekaHttpClientUtils.mappingJacksonHttpMessageConverter());
        restTemplate.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
        restTemplate.getInterceptors().add((request, body, execution) -> {
            ClientHttpResponse response = execution.execute(request, body);
            if (!response.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
                return response;
            }
            return new NotFoundHttpResponse(response);
        });
        return restTemplate;
    }

    public void shutdown() {
    }

    class ErrorHandler
    extends DefaultResponseErrorHandler {
        ErrorHandler() {
        }

        protected boolean hasError(HttpStatusCode statusCode) {
            if (statusCode.is4xxClientError()) {
                return false;
            }
            return super.hasError(statusCode);
        }
    }
}

