/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.eureka.http.EurekaApplications;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateEurekaHttpClient
implements EurekaHttpClient {
    private final RestTemplate restTemplate;
    private String serviceUrl;

    public RestTemplateEurekaHttpClient(RestTemplate restTemplate, String serviceUrl) {
        this.restTemplate = restTemplate;
        this.serviceUrl = serviceUrl;
        if (!serviceUrl.endsWith("/")) {
            this.serviceUrl = this.serviceUrl + "/";
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path("apps/{appName}").buildAndExpand(new Object[]{info.getAppName()}).toUri();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept-Encoding", "gzip");
        headers.add("Content-Type", "application/json");
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, new HttpEntity((Object)info, (MultiValueMap)headers), Void.class);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path("apps/{appName}/{id}").buildAndExpand(new Object[]{appName, id}).toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.DELETE, null, Void.class);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path("apps/{appName}/{id}").queryParam("status", new Object[]{info.getStatus().toString()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()});
        if (overriddenStatus != null) {
            uriBuilder = uriBuilder.queryParam("overriddenstatus", new Object[]{overriddenStatus.name()});
        }
        URI uri = uriBuilder.buildAndExpand(new Object[]{appName, id}).toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.PUT, null, InstanceInfo.class);
        EurekaHttpResponse.EurekaHttpResponseBuilder eurekaResponseBuilder = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value(), InstanceInfo.class).headers(RestTemplateEurekaHttpClient.headersOf(response));
        if (response.hasBody()) {
            eurekaResponseBuilder.entity((Object)((InstanceInfo)response.getBody()));
        }
        return eurekaResponseBuilder.build();
    }

    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path("apps/{appName}/{id}/status").queryParam("value", new Object[]{newStatus.name()}).queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).buildAndExpand(new Object[]{appName, id}).toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.PUT, null, Void.class);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path("apps/{appName}/{id}/status").queryParam("lastDirtyTimestamp", new Object[]{info.getLastDirtyTimestamp().toString()}).buildAndExpand(new Object[]{appName, id}).toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.DELETE, null, Void.class);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path(urlPath);
        if (regions != null && regions.length > 0) {
            uriBuilder = uriBuilder.queryParam("regions", new Object[]{StringUtil.join((String[])regions)});
        }
        URI uri = uriBuilder.build().toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, null, EurekaApplications.class);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value(), response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (Applications)response.getBody() : null).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    public EurekaHttpResponse<Application> getApplication(String appName) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).path("apps/{appName}").buildAndExpand(new Object[]{appName}).toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, null, Application.class);
        Application application = response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (Application)response.getBody() : null;
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value(), (Object)application).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps", appName, id);
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances", id);
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String ... pathSegments) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)this.serviceUrl).pathSegment(pathSegments).build().toUri();
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, null, InstanceInfo.class);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCode().value(), response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (InstanceInfo)response.getBody() : null).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public void shutdown() {
    }

    private static Map<String, String> headersOf(ResponseEntity<?> response) {
        HttpHeaders httpHeaders = response.getHeaders();
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : httpHeaders.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            headers.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        return headers;
    }
}

