/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.eureka.http.EurekaApplications;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateEurekaHttpClient
implements EurekaHttpClient {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private RestTemplate restTemplate;
    private String serviceUrl;

    public RestTemplateEurekaHttpClient(RestTemplate restTemplate, String serviceUrl) {
        this.restTemplate = restTemplate;
        this.serviceUrl = serviceUrl;
        if (!serviceUrl.endsWith("/")) {
            this.serviceUrl = this.serviceUrl + "/";
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        String urlPath = this.serviceUrl + "apps/" + info.getAppName();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept-Encoding", "gzip");
        headers.add("Content-Type", "application/json");
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.POST, new HttpEntity((Object)info, (MultiValueMap)headers), Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        String urlPath = this.serviceUrl + "apps/" + appName + '/' + id;
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.DELETE, null, Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        String urlPath = this.serviceUrl + "apps/" + appName + '/' + id + "?status=" + info.getStatus().toString() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString() + (overriddenStatus != null ? "&overriddenstatus=" + overriddenStatus.name() : "");
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.PUT, null, InstanceInfo.class, new Object[0]);
        EurekaHttpResponse.EurekaHttpResponseBuilder eurekaResponseBuilder = EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue(), InstanceInfo.class).headers(RestTemplateEurekaHttpClient.headersOf(response));
        if (response.hasBody()) {
            eurekaResponseBuilder.entity((Object)((InstanceInfo)response.getBody()));
        }
        return eurekaResponseBuilder.build();
    }

    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        String urlPath = this.serviceUrl + "apps/" + appName + '/' + id + "/status?value=" + newStatus.name() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.PUT, null, Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        String urlPath = this.serviceUrl + "apps/" + appName + '/' + id + "/status?lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.DELETE, null, Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        String url = this.serviceUrl + urlPath;
        if (regions != null && regions.length > 0) {
            url = url + (urlPath.contains("?") ? "&" : "?") + "regions=" + StringUtil.join((String[])regions);
        }
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, null, EurekaApplications.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue(), response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (Applications)response.getBody() : null).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    public EurekaHttpResponse<Application> getApplication(String appName) {
        String urlPath = this.serviceUrl + "apps/" + appName;
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.GET, null, Application.class, new Object[0]);
        Application application = response.getStatusCodeValue() == HttpStatus.OK.value() && response.hasBody() ? (Application)response.getBody() : null;
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue(), (Object)application).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps/" + appName + '/' + id);
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances/" + id);
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        urlPath = this.serviceUrl + urlPath;
        ResponseEntity response = this.restTemplate.exchange(urlPath, HttpMethod.GET, null, InstanceInfo.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse((int)response.getStatusCodeValue(), response.getStatusCodeValue() == HttpStatus.OK.value() && response.hasBody() ? (InstanceInfo)response.getBody() : null).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    public void shutdown() {
    }

    private static Map<String, String> headersOf(ResponseEntity<?> response) {
        HttpHeaders httpHeaders = response.getHeaders();
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : httpHeaders.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            headers.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        return headers;
    }
}

