/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.endpoint.EndpointUtils;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import java.util.List;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

final class HostnameBasedUrlRandomizer
implements EndpointUtils.ServiceUrlRandomizer {
    private final String hostname;

    HostnameBasedUrlRandomizer(String hostname) {
        this.hostname = hostname;
    }

    public void randomize(List<String> urlList) {
        int listSize = 0;
        if (urlList != null) {
            listSize = urlList.size();
        }
        if (!StringUtils.hasText((String)this.hostname) || listSize == 0) {
            return;
        }
        int instanceHashcode = this.hostname.hashCode();
        if (instanceHashcode < 0) {
            instanceHashcode *= -1;
        }
        int backupInstance = instanceHashcode % listSize;
        for (int i = 0; i < backupInstance; ++i) {
            String zone = urlList.remove(0);
            urlList.add(zone);
        }
    }

    static String getEurekaUrl(EurekaClientConfigBean config, String hostname) {
        List urls = EndpointUtils.getDiscoveryServiceUrls((EurekaClientConfig)config, (String)"defaultZone", (EndpointUtils.ServiceUrlRandomizer)new HostnameBasedUrlRandomizer(hostname));
        return (String)urls.get(0);
    }

    static DefaultEndpoint randomEndpoint(EurekaClientConfigBean config, Environment env) {
        String hostname = env.getProperty("eureka.instance.hostname");
        return new DefaultEndpoint(HostnameBasedUrlRandomizer.getEurekaUrl(config, hostname));
    }

    static DefaultEndpoint randomEndpoint(EurekaClientConfigBean config, Binder binder) {
        String hostname = (String)binder.bind("eureka.instance.hostname", String.class).orElseGet(() -> null);
        return new DefaultEndpoint(HostnameBasedUrlRandomizer.getEurekaUrl(config, hostname));
    }
}

