/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.loadbalancer;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.EurekaClientConfig;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.netflix.eureka.loadbalancer.EurekaLoadBalancerProperties;
import org.springframework.cloud.netflix.ribbon.eureka.ZoneUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(value={LoadBalancerZoneConfig.class, EurekaLoadBalancerProperties.class})
public class EurekaLoadBalancerClientConfiguration {
    private static final Log LOG = LogFactory.getLog(EurekaLoadBalancerClientConfiguration.class);
    private final EurekaClientConfig clientConfig;
    private final EurekaInstanceConfig eurekaConfig;
    private final LoadBalancerZoneConfig zoneConfig;
    private final EurekaLoadBalancerProperties eurekaLoadBalancerProperties;

    public EurekaLoadBalancerClientConfiguration(@Autowired(required=false) EurekaClientConfig clientConfig, @Autowired(required=false) EurekaInstanceConfig eurekaInstanceConfig, LoadBalancerZoneConfig zoneConfig, EurekaLoadBalancerProperties eurekaLoadBalancerProperties) {
        this.clientConfig = clientConfig;
        this.eurekaConfig = eurekaInstanceConfig;
        this.zoneConfig = zoneConfig;
        this.eurekaLoadBalancerProperties = eurekaLoadBalancerProperties;
    }

    @PostConstruct
    public void postprocess() {
        if (!StringUtils.isEmpty((Object)this.zoneConfig.getZone())) {
            return;
        }
        String zone = this.getZoneFromEureka();
        if (!StringUtils.isEmpty((Object)zone)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting the value of 'spring.cloud.loadbalancer.zone' to " + zone));
            }
            this.zoneConfig.setZone(zone);
        }
    }

    private String getZoneFromEureka() {
        String zone;
        boolean approximateZoneFromHostname = this.eurekaLoadBalancerProperties.isApproximateZoneFromHostname();
        if (approximateZoneFromHostname && this.eurekaConfig != null) {
            return ZoneUtils.extractApproximateZone(this.eurekaConfig.getHostName(false));
        }
        String string = zone = this.eurekaConfig == null ? null : (String)this.eurekaConfig.getMetadataMap().get("zone");
        if (StringUtils.isEmpty(zone)) {
            String[] zones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
            zone = zones != null && zones.length > 0 ? zones[0] : null;
        }
        return zone;
    }
}

