/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class LoadBalancerHttpServletRequest
implements HttpServletRequest {
    private final @Nullable RequestData requestData;

    public LoadBalancerHttpServletRequest(@Nullable RequestData requestData) {
        this.requestData = requestData;
    }

    public @Nullable String getAuthType() {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return null;
        }
        String authHeader = this.requestData.getHeaders().getFirst("Authorization");
        if (authHeader == null) {
            return null;
        }
        if (authHeader.startsWith("Basic ")) {
            return "BASIC";
        }
        if (authHeader.startsWith("Digest ")) {
            return "DIGEST";
        }
        if (authHeader.startsWith("Bearer ")) {
            return "BEARER";
        }
        return null;
    }

    public Cookie[] getCookies() {
        if (this.requestData == null) {
            return new Cookie[0];
        }
        MultiValueMap cookies = this.requestData.getCookies();
        if (cookies == null || cookies.isEmpty()) {
            return new Cookie[0];
        }
        return (Cookie[])cookies.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(cookieEntryValue -> new Cookie((String)entry.getKey(), cookieEntryValue))).toArray(Cookie[]::new);
    }

    public long getDateHeader(String name) {
        String headerValue;
        String string = headerValue = this.requestData == null || this.requestData.getHeaders() == null ? null : this.requestData.getHeaders().getFirst(name);
        if (headerValue == null) {
            return -1L;
        }
        try {
            ZonedDateTime dateTime = ZonedDateTime.parse(headerValue, DateTimeFormatter.RFC_1123_DATE_TIME);
            return dateTime.toInstant().toEpochMilli();
        }
        catch (DateTimeParseException exception) {
            throw new IllegalArgumentException("Cannot convert header [" + name + "] value [" + headerValue + "] to Date", exception);
        }
    }

    public @Nullable String getHeader(String name) {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return null;
        }
        return this.requestData.getHeaders().getFirst(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        List headerValues = this.requestData.getHeaders().get(name);
        return headerValues != null ? Collections.enumeration(headerValues) : Collections.emptyEnumeration();
    }

    public Enumeration<String> getHeaderNames() {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        HttpHeaders headers = this.requestData.getHeaders();
        Set headerNames = headers.headerNames();
        return Collections.enumeration(headerNames);
    }

    public int getIntHeader(String name) {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return -1;
        }
        String headerValue = this.requestData.getHeaders().getFirst(name);
        if (headerValue == null) {
            return -1;
        }
        try {
            return Integer.parseInt(headerValue);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Cannot convert header [" + name + "] value [" + headerValue + "] to int");
        }
    }

    public @Nullable String getMethod() {
        if (this.requestData == null) {
            return null;
        }
        return this.requestData.getHttpMethod().name();
    }

    public @Nullable String getPathInfo() {
        if (this.requestData == null) {
            return null;
        }
        URI uri = this.requestData.getUrl();
        return uri.getPath();
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public String getContextPath() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable String getQueryString() {
        if (this.requestData == null) {
            return null;
        }
        return this.requestData.getUrl().getRawQuery();
    }

    public @Nullable String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        return principal != null ? principal.getName() : null;
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable Principal getUserPrincipal() {
        if (this.requestData == null) {
            return null;
        }
        Object principal = this.requestData.getAttributes().get(Principal.class.getName());
        if (principal instanceof Principal) {
            return (Principal)principal;
        }
        return null;
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable String getRequestURI() {
        if (this.requestData == null) {
            return null;
        }
        return this.requestData.getUrl().getRawPath();
    }

    public @Nullable StringBuffer getRequestURL() {
        if (this.requestData == null) {
            return null;
        }
        URI uri = this.requestData.getUrl();
        StringBuffer url = new StringBuffer();
        url.append(uri.getScheme()).append("://").append(uri.getHost());
        int port = uri.getPort();
        if (!(port == -1 || "http".equals(uri.getScheme()) && port == 80 || "https".equals(uri.getScheme()) && port == 443)) {
            url.append(':').append(port);
        }
        url.append(uri.getRawPath());
        return url;
    }

    public String getServletPath() {
        return "";
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return Collections.emptyList();
    }

    public @Nullable Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable Object getAttribute(String name) {
        if (this.requestData == null) {
            return null;
        }
        return this.requestData.getAttributes().get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.requestData == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.requestData.getAttributes().keySet());
    }

    public @Nullable String getCharacterEncoding() {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return null;
        }
        String contentTypeHeader = this.requestData.getHeaders().getFirst("Content-Type");
        if (contentTypeHeader == null) {
            return null;
        }
        try {
            Charset charset = MediaType.parseMediaType((String)contentTypeHeader).getCharset();
            if (charset == null) {
                return null;
            }
            return charset.name();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public int getContentLength() {
        long contentLength = this.getContentLengthLong();
        if (contentLength > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)contentLength;
    }

    public long getContentLengthLong() {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return -1L;
        }
        String contentLength = this.requestData.getHeaders().getFirst("Content-Length");
        if (contentLength == null) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public @Nullable String getContentType() {
        if (this.requestData == null || this.requestData.getHeaders() == null) {
            return null;
        }
        return this.requestData.getHeaders().getFirst("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.requestData == null) {
            return Collections.emptyMap();
        }
        return UriComponentsBuilder.fromUri((URI)this.requestData.getUrl()).build().getQueryParams().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toArray(new String[0])));
    }

    public String getProtocol() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable String getScheme() {
        if (this.requestData == null) {
            return null;
        }
        return this.requestData.getUrl().getScheme();
    }

    public @Nullable String getServerName() {
        if (this.requestData == null) {
            return null;
        }
        return this.requestData.getUrl().getHost();
    }

    public int getServerPort() {
        int port = -1;
        if (this.requestData != null) {
            port = this.requestData.getUrl().getPort();
        }
        if (port == -1) {
            return "https".equals(this.getScheme()) ? 443 : 80;
        }
        return port;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public void setAttribute(String name, @Nullable Object o) {
        if (o == null) {
            this.removeAttribute(name);
        } else if (this.requestData != null) {
            this.requestData.getAttributes().put(name, o);
        }
    }

    public void removeAttribute(String name) {
        if (this.requestData != null) {
            this.requestData.getAttributes().remove(name);
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singletonList(Locale.getDefault()));
    }

    public boolean isSecure() {
        if (this.requestData == null) {
            return false;
        }
        return "https".equalsIgnoreCase(this.requestData.getUrl().getScheme());
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public @Nullable String getLocalName() {
        return this.getServerName();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public @Nullable AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public String getRequestId() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public String getProtocolRequestId() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }

    public ServletConnection getServletConnection() {
        throw new UnsupportedOperationException("Not available for " + this.getClass().getSimpleName());
    }
}

