/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.ServiceInstance;

class LazyWeightedServiceInstanceList
extends AbstractList<ServiceInstance> {
    final ServiceInstance[] expanded;
    private final Object expandingLock = new Object();
    private @Nullable WeightedServiceInstanceSelector selector;
    private volatile int position = 0;

    LazyWeightedServiceInstanceList(List<ServiceInstance> instances, int[] weights) {
        int greatestCommonDivisor = 0;
        int total = 0;
        for (int weight : weights) {
            greatestCommonDivisor = LazyWeightedServiceInstanceList.greatestCommonDivisor(greatestCommonDivisor, weight);
            total += weight;
        }
        this.expanded = new ServiceInstance[total / greatestCommonDivisor];
        this.selector = new WeightedServiceInstanceSelector(instances, weights, greatestCommonDivisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInstance get(int index) {
        if (index >= this.position) {
            Object object = this.expandingLock;
            synchronized (object) {
                while (this.position <= index && this.position < this.expanded.length) {
                    if (this.selector != null) {
                        this.expanded[this.position] = this.selector.next();
                    }
                    ++this.position;
                }
                if (this.position == this.expanded.length) {
                    this.selector = null;
                }
            }
        }
        return this.expanded[index];
    }

    @Override
    public int size() {
        return this.expanded.length;
    }

    static int greatestCommonDivisor(int a, int b) {
        while (b != 0) {
            int r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    static class WeightedServiceInstanceSelector {
        Queue<Entry> active;
        Queue<Entry> expired;

        WeightedServiceInstanceSelector(List<ServiceInstance> instances, int[] weights, int greatestCommonDivisor) {
            this.active = new ArrayDeque<Entry>(instances.size());
            this.expired = new ArrayDeque<Entry>(instances.size());
            int i = 0;
            for (ServiceInstance instance : instances) {
                this.active.offer(new Entry(instance, weights[i] / greatestCommonDivisor));
                ++i;
            }
        }

        ServiceInstance next() {
            Entry entry;
            if (this.active.isEmpty()) {
                Queue<Entry> temp = this.active;
                this.active = this.expired;
                this.expired = temp;
            }
            if ((entry = this.active.poll()) == null) {
                return null;
            }
            --entry.remainder;
            if (entry.remainder == 0) {
                entry.remainder = entry.weight;
                this.expired.offer(entry);
            } else {
                this.active.offer(entry);
            }
            return entry.instance;
        }

        static class Entry {
            final ServiceInstance instance;
            final int weight;
            int remainder;

            Entry(ServiceInstance instance, int weight) {
                this.instance = instance;
                this.weight = weight;
                this.remainder = weight;
            }
        }
    }
}

