/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.annotation;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class LoadBalancerClientConfigurationRegistrar
implements ImportBeanDefinitionRegistrar {
    private static String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("value");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @LoadBalancerClient");
    }

    private static void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(LoadBalancerClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(String.valueOf(name) + ".LoadBalancerClientSpecification", (BeanDefinition)builder.getBeanDefinition());
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map client;
        String name;
        Map attrs = metadata.getAnnotationAttributes(LoadBalancerClients.class.getName());
        if (attrs != null && attrs.containsKey("value")) {
            AnnotationAttributes[] clients;
            for (AnnotationAttributes client2 : clients = (AnnotationAttributes[])attrs.get("value")) {
                LoadBalancerClientConfigurationRegistrar.registerClientConfiguration(registry, LoadBalancerClientConfigurationRegistrar.getClientName((Map<String, Object>)client2), client2.get((Object)"configuration"));
            }
        }
        if (attrs != null && attrs.containsKey("defaultConfiguration")) {
            String name2 = metadata.hasEnclosingClass() ? "default." + metadata.getEnclosingClassName() : "default." + metadata.getClassName();
            LoadBalancerClientConfigurationRegistrar.registerClientConfiguration(registry, name2, attrs.get("defaultConfiguration"));
        }
        if ((name = LoadBalancerClientConfigurationRegistrar.getClientName(client = metadata.getAnnotationAttributes(LoadBalancerClient.class.getName()))) != null) {
            LoadBalancerClientConfigurationRegistrar.registerClientConfiguration(registry, name, client.get("configuration"));
        }
    }
}

