/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.blocking.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class BlockingLoadBalancerClient
implements LoadBalancerClient {
    private final LoadBalancerClientFactory loadBalancerClientFactory;
    private final LoadBalancerProperties properties;

    public BlockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory, LoadBalancerProperties properties) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        this.properties = properties;
    }

    public <T> T execute(String serviceId, LoadBalancerRequest<T> request) throws IOException {
        String hint = this.getHint(serviceId);
        DefaultRequest lbRequest = new DefaultRequest((Object)new DefaultRequestContext(request, hint));
        Set supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.loadBalancerClientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), DefaultRequestContext.class, Object.class, ServiceInstance.class);
        supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onStart((Request)lbRequest));
        ServiceInstance serviceInstance = this.choose(serviceId, (Request<T>)lbRequest);
        if (serviceInstance == null) {
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.DISCARD, (Response)new EmptyResponse())));
            throw new IllegalStateException("No instances available for " + serviceId);
        }
        return this.execute(serviceId, serviceInstance, request);
    }

    public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
        DefaultResponse defaultResponse = new DefaultResponse(serviceInstance);
        Set supportedLifecycleProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors((Map)this.loadBalancerClientFactory.getInstances(serviceId, LoadBalancerLifecycle.class), DefaultRequestContext.class, Object.class, ServiceInstance.class);
        try {
            Object response = request.apply(serviceInstance);
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, (Response)defaultResponse, response)));
            return (T)response;
        }
        catch (IOException iOException) {
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)iOException, (Response)defaultResponse)));
            throw iOException;
        }
        catch (Exception exception) {
            supportedLifecycleProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.FAILED, (Throwable)exception, (Response)defaultResponse)));
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
            return null;
        }
    }

    public URI reconstructURI(ServiceInstance serviceInstance, URI original) {
        return LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
    }

    public ServiceInstance choose(String serviceId) {
        return this.choose(serviceId, ReactiveLoadBalancer.REQUEST);
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerClientFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return null;
        }
        Response loadBalancerResponse = (Response)Mono.from((Publisher)loadBalancer.choose(request)).block();
        if (loadBalancerResponse == null) {
            return null;
        }
        return (ServiceInstance)loadBalancerResponse.getServer();
    }

    private String getHint(String serviceId) {
        String defaultHint = this.properties.getHint().getOrDefault("default", "default");
        String hintPropertyValue = (String)this.properties.getHint().get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }
}

