/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons.fabric8_client;

import io.fabric8.kubernetes.api.model.APIServiceList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.springframework.cloud.kubernetes.integration.tests.commons.Images;
import org.springframework.cloud.kubernetes.integration.tests.commons.Phase;
import org.testcontainers.k3s.K3sContainer;

public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);
    private final K3sContainer container;
    private final KubernetesClient client;

    public Util(K3sContainer container) {
        this.container = container;
        this.client = new KubernetesClientBuilder().withConfig(Config.fromKubeconfig((String)container.getKubeConfigYaml())).build();
    }

    public void createAndWait(String namespace, String name, @Nullable Deployment deployment, @Nullable Service service, boolean changeVersion) {
        try {
            if (deployment != null) {
                String imageFromDeployment = ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
                if (changeVersion) {
                    ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageFromDeployment + ":" + Commons.pomVersion());
                } else {
                    String[] image = imageFromDeployment.split(":", 2);
                    Commons.pullImage(image[0], image[1], name, this.container);
                    Commons.loadImage(image[0], image[1], name, this.container);
                }
                ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).create();
                this.waitForDeployment(namespace, deployment);
            }
            if (service != null) {
                ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).resource((Object)service)).create();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void busybox(String namespace, Phase phase) {
        InputStream deploymentStream = this.inputStream("busybox/deployment.yaml");
        InputStream serviceStream = this.inputStream("busybox/service.yaml");
        Deployment deployment = (Deployment)Serialization.unmarshal((InputStream)deploymentStream, Deployment.class);
        String busyboxVersion = Images.busyboxVersion();
        String imageWithoutVersion = ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + busyboxVersion;
        ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        Service service = (Service)Serialization.unmarshal((InputStream)serviceStream, Service.class);
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "busybox", deployment, service, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service);
        }
    }

    public void deleteAndWait(String namespace, @Nullable Deployment deployment, @Nullable Service service) {
        try {
            long startTime = System.currentTimeMillis();
            if (deployment != null) {
                List deploymentPods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(deployment.getSpec().getSelector().getMatchLabels())).list()).getItems();
                ((PropagationPolicyConfigurable)this.client.resourceList((KubernetesResourceList)((PodListBuilder)new PodListBuilder().withItems(deploymentPods)).build()).withGracePeriod(0L)).delete();
                ((PropagationPolicyConfigurable)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).withGracePeriod(0L)).delete();
                this.waitForDeploymentToBeDeleted(namespace, deployment);
            }
            System.out.println("Ended deployment delete in " + (System.currentTimeMillis() - startTime) + "ms");
            if (service != null) {
                ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).resource((Object)service)).delete();
                this.waitForServiceToBeDeleted(namespace, service);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUp(String namespace) throws Exception {
        InputStream serviceAccountAsStream = this.inputStream("setup/service-account.yaml");
        InputStream roleBindingAsStream = this.inputStream("setup/role-binding.yaml");
        InputStream roleAsStream = this.inputStream("setup/role.yaml");
        this.innerSetup(namespace, serviceAccountAsStream, roleBindingAsStream, roleAsStream);
    }

    public InputStream inputStream(String fileName) {
        return Util.class.getClassLoader().getResourceAsStream(fileName);
    }

    public void createNamespace(String name) {
        try {
            ((Resource)this.client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).and()).build())).create();
            Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> ((NamespaceList)this.client.namespaces().list()).getItems().stream().anyMatch(x -> x.getMetadata().getName().equals(name)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteNamespace(String name) {
        try {
            List apiServices = ((APIServiceList)this.client.apiServices().list()).getItems();
            apiServices.stream().map(apiService -> apiService.getMetadata().getName()).filter(apiServiceName -> apiServiceName.contains("metrics.k8s.io")).findFirst().ifPresent(apiServiceName -> ((Resource)this.client.apiServices().withName(apiServiceName)).delete());
            ((Resource)this.client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).and()).build())).delete();
            Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> ((NamespaceList)this.client.namespaces().list()).getItems().stream().noneMatch(x -> x.getMetadata().getName().equals(name)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createAndWait(String namespace, @Nullable ConfigMap configMap, @Nullable Secret secret) {
        if (configMap != null) {
            ((Resource)this.client.configMaps().resource((Object)configMap)).create();
            this.waitForConfigMap(namespace, configMap, Phase.CREATE);
        }
        if (secret != null) {
            ((Resource)this.client.secrets().resource((Object)secret)).create();
            this.waitForSecret(namespace, secret, Phase.CREATE);
        }
    }

    public void deleteAndWait(String namespace, @Nullable ConfigMap configMap, @Nullable Secret secret) {
        if (configMap != null) {
            ((Resource)this.client.configMaps().resource((Object)configMap)).delete();
            this.waitForConfigMap(namespace, configMap, Phase.DELETE);
        }
        if (secret != null) {
            ((Resource)this.client.secrets().resource((Object)secret)).delete();
            this.waitForSecret(namespace, secret, Phase.DELETE);
        }
    }

    public void setUpIstio(String namespace) {
        InputStream serviceAccountAsStream = this.inputStream("istio/service-account.yaml");
        InputStream roleBindingAsStream = this.inputStream("istio/role-binding.yaml");
        InputStream roleAsStream = this.inputStream("istio/role.yaml");
        this.innerSetup(namespace, serviceAccountAsStream, roleBindingAsStream, roleAsStream);
    }

    public void setUpIstioctl(String namespace, Phase phase) {
        InputStream istioctlDeploymentStream = this.inputStream("istio/istioctl-deployment.yaml");
        Deployment istioctlDeployment = (Deployment)Serialization.unmarshal((InputStream)istioctlDeploymentStream, Deployment.class);
        String imageWithoutVersion = ((Container)istioctlDeployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.istioVersion();
        ((Container)istioctlDeployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, null, istioctlDeployment, null, false);
        } else {
            this.deleteAndWait(namespace, istioctlDeployment, null);
        }
    }

    private void waitForConfigMap(String namespace, ConfigMap configMap, Phase phase) {
        String configMapName = this.configMapName(configMap);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            int size = (int)((ConfigMapList)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).list()).getItems().stream().filter(x -> x.getMetadata().getName().equals(configMapName)).count();
            if (size == 0) {
                return !phase.equals((Object)Phase.CREATE);
            }
            return phase.equals((Object)Phase.CREATE);
        });
    }

    public void wiremock(String namespace, Phase phase, boolean withNodePort) {
        InputStream deploymentStream = this.inputStream("wiremock/wiremock-deployment.yaml");
        InputStream serviceStream = this.inputStream("wiremock/wiremock-service.yaml");
        Deployment deployment = (Deployment)Serialization.unmarshal((InputStream)deploymentStream, Deployment.class);
        String imageWithoutVersion = ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
        String imageWithVersion = imageWithoutVersion + ":" + Images.wiremockVersion();
        ((Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageWithVersion);
        Service service = (Service)Serialization.unmarshal((InputStream)serviceStream, Service.class);
        if (!withNodePort) {
            ((ServicePort)service.getSpec().getPorts().get(0)).setNodePort(null);
            service.getSpec().setType("ClusterIP");
        }
        if (phase.equals((Object)Phase.CREATE)) {
            deployment.getMetadata().setNamespace(namespace);
            service.getMetadata().setNamespace(namespace);
            this.createAndWait(namespace, "wiremock", deployment, service, false);
        } else {
            this.deleteAndWait(namespace, deployment, service);
        }
    }

    public void configWatcher(Phase phase) {
        InputStream deploymentStream = this.inputStream("config-watcher/deployment.yaml");
        InputStream serviceStream = this.inputStream("config-watcher/service.yaml");
        Deployment deployment = (Deployment)((RollableScalableResource)this.client.apps().deployments().load(deploymentStream)).item();
        Service service = (Service)((ServiceResource)this.client.services().load(serviceStream)).item();
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait("default", deployment.getMetadata().getName(), deployment, service, true);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait("default", deployment, service);
        }
    }

    private void waitForSecret(String namespace, Secret secret, Phase phase) {
        String secretName = this.secretName(secret);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            int size = (int)((SecretList)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).list()).getItems().stream().filter(x -> x.getMetadata().getName().equals(secretName)).count();
            if (size == 0) {
                return !phase.equals((Object)Phase.CREATE);
            }
            return phase.equals((Object)Phase.CREATE);
        });
    }

    private void waitForDeploymentToBeDeleted(String namespace, Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Map matchLabels = deployment.getSpec().getSelector().getMatchLabels();
        long start = System.currentTimeMillis();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Deployment inner = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
            return inner == null;
        });
        System.out.println("Ended in " + (System.currentTimeMillis() - start) + "ms");
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(60L, TimeUnit.SECONDS).until(() -> {
            List podList = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
            return podList == null || podList.isEmpty();
        });
    }

    private void waitForServiceToBeDeleted(String namespace, Service service) {
        String serviceName = service.getMetadata().getName();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> {
            Service inner = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get();
            return inner == null;
        });
    }

    private void waitForDeployment(String namespace, Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Awaitility.await().pollInterval(Duration.ofSeconds(2L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isDeploymentReady(namespace, deploymentName));
    }

    private boolean isDeploymentReady(String namespace, String deploymentName) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        Integer availableReplicas = deployment.getStatus().getAvailableReplicas();
        LOG.info((Object)("Available replicas for " + deploymentName + ": " + (availableReplicas == null ? 0 : 1)));
        return availableReplicas != null && availableReplicas >= 1;
    }

    private void innerSetup(String namespace, InputStream serviceAccountAsStream, InputStream roleBindingAsStream, InputStream roleAsStream) {
        ServiceAccount serviceAccount = (ServiceAccount)Serialization.unmarshal((InputStream)serviceAccountAsStream, ServiceAccount.class);
        if (((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).withName(serviceAccount.getMetadata().getName())).get() == null) {
            ((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).resource((Object)serviceAccount)).create();
        }
        RoleBinding roleBinding = (RoleBinding)Serialization.unmarshal((InputStream)roleBindingAsStream, RoleBinding.class);
        if (((Resource)((NonNamespaceOperation)this.client.rbac().roleBindings().inNamespace(namespace)).withName(roleBinding.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)this.client.rbac().roleBindings().inNamespace(namespace)).resource((Object)roleBinding)).create();
        }
        Role roleFromStream = (Role)Serialization.unmarshal((InputStream)roleAsStream, Role.class);
        if (((Resource)((NonNamespaceOperation)this.client.rbac().roles().inNamespace(namespace)).withName(roleFromStream.getMetadata().getName())).get() == null) {
            ((Resource)((NonNamespaceOperation)this.client.rbac().roles().inNamespace(namespace)).resource((Object)roleFromStream)).create();
        }
    }

    private String deploymentName(Deployment deployment) {
        return deployment.getMetadata().getName();
    }

    private String configMapName(ConfigMap configMap) {
        return configMap.getMetadata().getName();
    }

    private String secretName(Secret secret) {
        return secret.getMetadata().getName();
    }

    public KubernetesClient client() {
        return this.client;
    }
}

