/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.testcontainers.k3s.K3sContainer;

public final class Images {
    private static final String BUSYBOX = "busybox";
    private static final String BUSYBOX_TAR = "busybox:" + Images.busyboxVersion();
    private static final String WIREMOCK = "wiremock/wiremock";
    private static final String WIREMOCK_TAR = "wiremock/wiremock".replace('/', '-') + ":" + Images.wiremockVersion();
    private static final String ISTIOCTL = "istio/istioctl";
    private static final String ISTIOCTL_TAR = "istio/istioctl".replace('/', '-') + ":" + Images.istioVersion();
    private static final String ISTIO_PROXY_V2 = "istio/proxyv2";
    private static final String ISTIO_PROXY_V2_TAR = "istio/proxyv2".replace('/', '-') + ":" + Images.istioVersion();
    private static final String ISTIO_PILOT = "istio/pilot";
    private static final String ISTIO_PILOT_TAR = "istio/pilot".replace('/', '-') + ":" + Images.istioVersion();
    private static final String KAFKA = "confluentinc/confluent-local";
    private static final String KAFKA_TAR = "confluentinc/confluent-local".replace('/', '-') + Images.kafkaVersion();
    private static final String RABBITMQ = "rabbitmq";
    private static final String RABBITMQ_TAR = "rabbitmq";

    private Images() {
    }

    public static String busyboxVersion() {
        return Images.imageVersion(BUSYBOX);
    }

    public static String istioVersion() {
        return Images.imageVersion(ISTIOCTL);
    }

    public static String kafkaVersion() {
        return Images.imageVersion(KAFKA);
    }

    public static String rabbitMqVersion() {
        return Images.imageVersion("rabbitmq");
    }

    public static String wiremockVersion() {
        return Images.imageVersion(WIREMOCK);
    }

    public static void loadBusybox(K3sContainer container) {
        if (!Images.imageAlreadyInK3s(container, BUSYBOX_TAR)) {
            Commons.load(container, BUSYBOX_TAR, BUSYBOX, Images.busyboxVersion());
        }
    }

    public static void loadWiremock(K3sContainer container) {
        if (!Images.imageAlreadyInK3s(container, WIREMOCK_TAR)) {
            Commons.load(container, WIREMOCK_TAR, WIREMOCK, Images.wiremockVersion());
        }
    }

    public static void loadIstioCtl(K3sContainer container) {
        Commons.load(container, ISTIOCTL_TAR, ISTIOCTL, Images.istioVersion());
    }

    public static void loadIstioProxyV2(K3sContainer container) {
        Commons.load(container, ISTIO_PROXY_V2_TAR, ISTIO_PROXY_V2, Images.istioVersion());
    }

    public static void loadIstioPilot(K3sContainer container) {
        Commons.load(container, ISTIO_PILOT_TAR, ISTIO_PILOT, Images.istioVersion());
    }

    public static void loadKafka(K3sContainer container) {
        Commons.load(container, KAFKA_TAR, KAFKA, Images.kafkaVersion());
    }

    public static void loadRabbitmq(K3sContainer container) {
        Commons.load(container, "rabbitmq", "rabbitmq", Images.rabbitMqVersion());
    }

    private static boolean imageAlreadyInK3s(K3sContainer container, String tarName) {
        try {
            boolean present = container.execInContainer(new String[]{"sh", "-c", "ctr images list | grep " + tarName}).getStdout().contains(tarName);
            if (present) {
                System.out.println("image : " + tarName + " already in k3s, skipping");
                return true;
            }
            System.out.println("image : " + tarName + " not in k3s");
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String imageVersion(String imageNameForDownload) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Commons.class.getClassLoader().getResourceAsStream("current-images.txt")));
        return reader.lines().filter(line -> line.contains(imageNameForDownload)).map(line -> line.split(":")[1]).findFirst().orElseThrow();
    }
}

