/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.k3s.K3sContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public final class Commons {
    private static final Log LOG = LogFactory.getLog(Commons.class);
    public static final String ISTIO_VERSION = "1.16.0";
    private static final String LOCAL_ISTIO_BIN_PATH = "istio-cli/istio-1.16.0/bin";
    private static final String KUBERNETES_VERSION_FILE = "META-INF/springcloudkubernetes-version.txt";
    public static final String RANCHER = "rancher/k3s:v1.25.4-k3s1";
    public static final String RANCHER_COMMAND = "server";
    public static final int[] EXPOSED_PORTS = new int[]{80, 6443, 8080, 8888, 9092};
    public static final String TEMP_FOLDER = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
    private static final K3sContainer CONTAINER = (K3sContainer)((K3sContainer)((K3sContainer)((K3sContainer)new FixedPortsK3sContainer(DockerImageName.parse((String)"rancher/k3s:v1.25.4-k3s1")).configureFixedPorts(EXPOSED_PORTS).withFileSystemBind(TEMP_FOLDER, TEMP_FOLDER)).withCopyFileToContainer(MountableFile.forClasspathResource((String)"istio-cli/istio-1.16.0/bin/istioctl", (Integer)484), "/tmp/istioctl")).withCommand("server")).withReuse(true);

    private Commons() {
        throw new AssertionError((Object)"No instance provided");
    }

    public static K3sContainer container() {
        return CONTAINER;
    }

    public static void loadSpringCloudKubernetesImage(String project, K3sContainer container) throws Exception {
        Commons.loadImage("springcloud/" + project, Commons.pomVersion(), project, container);
    }

    public static void assertReloadLogStatements(String left, String right, String appLabel) {
        try {
            String appPodName = CONTAINER.execInContainer(new String[]{"sh", "-c", "kubectl get pods -l app=" + appLabel + " -o=name --no-headers | tr -d '\n'"}).getStdout();
            LOG.info((Object)("appPodName : ->" + appPodName + "<-"));
            Awaitility.await().pollDelay(20L, TimeUnit.SECONDS).pollInterval(Duration.ofSeconds(5L)).atMost(Duration.ofSeconds(120L)).until(() -> {
                Container.ExecResult result = CONTAINER.execInContainer(new String[]{"sh", "-c", "kubectl logs " + appPodName.trim() + "| grep '" + left + "'"});
                String error = result.getStderr();
                String ok = result.getStdout();
                LOG.info((Object)("error is : -->" + error + "<--"));
                if (ok != null && !ok.isBlank()) {
                    if (!right.isBlank()) {
                        String notPresent = CONTAINER.execInContainer(new String[]{"sh", "-c", "kubectl logs " + appPodName.trim() + "| grep '" + right + "'"}).getStdout();
                        Assertions.assertTrue((notPresent == null || notPresent.isBlank() ? 1 : 0) != 0);
                    }
                    return true;
                }
                LOG.info((Object)"log statement not yet present");
                return false;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadImage(String image, String tag, String tarName, K3sContainer container) throws Exception {
        try (SaveImageCmd saveImageCmd = container.getDockerClient().saveImageCmd(image);){
            InputStream imageStream = saveImageCmd.withTag(tag).exec();
            Path imagePath = Paths.get(TEMP_FOLDER + "/" + tarName + ".tar", new String[0]);
            Files.deleteIfExists(imagePath);
            Files.copy(imageStream, imagePath, new CopyOption[0]);
            Awaitility.await().atMost(Duration.ofMinutes(2L)).pollInterval(Duration.ofSeconds(1L)).until(() -> {
                boolean noErrors;
                Container.ExecResult result = container.execInContainer(new String[]{"ctr", "i", "import", TEMP_FOLDER + "/" + tarName + ".tar"});
                boolean bl = noErrors = result.getStderr() == null || result.getStderr().isEmpty();
                if (!noErrors) {
                    LOG.info((Object)("error is : " + result.getStderr()));
                }
                return noErrors;
            });
        }
    }

    public static void cleanUp(String image, K3sContainer container) throws Exception {
        container.execInContainer(new String[]{"crictl", "rmi", "docker.io/springcloud/" + image + ":" + Commons.pomVersion()});
        container.execInContainer(new String[]{"rm", TEMP_FOLDER + "/" + image + ".tar"});
    }

    public static void cleanUpDownloadedImage(String image) throws Exception {
        CONTAINER.execInContainer(new String[]{"crictl", "rmi", image});
    }

    public static void validateImage(String image, K3sContainer container) {
        try (ListImagesCmd listImagesCmd = container.getDockerClient().listImagesCmd();){
            List images = (List)listImagesCmd.exec();
            images.stream().filter(x -> Arrays.stream(x.getRepoTags() == null ? new String[]{} : x.getRepoTags()).anyMatch(y -> y.contains(image))).findFirst().orElseThrow(() -> new IllegalArgumentException("Image : " + image + " not build locally. You need to build it first, and then run the test"));
        }
    }

    public static void pullImage(String image, String tag, K3sContainer container) throws InterruptedException {
        try (PullImageCmd pullImageCmd = container.getDockerClient().pullImageCmd(image);){
            pullImageCmd.withTag(tag).start().awaitCompletion();
        }
    }

    public static String processExecResult(Container.ExecResult execResult) {
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("stdout=" + execResult.getStdout() + "\nstderr=" + execResult.getStderr());
        }
        return execResult.getStdout();
    }

    public static void systemPrune() {
        try {
            CONTAINER.execInContainer(new String[]{"sh", "-c", "crictl ps -a | grep -v Running | awk '{print $1}' | xargs crictl rm && crictl rmi --prune"});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String pomVersion() {
        String string;
        block9: {
            InputStream in = new ClassPathResource(KUBERNETES_VERSION_FILE).getInputStream();
            try {
                String version = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.hasText((String)version)) {
                    version = version.trim();
                }
                string = version;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return string;
    }

    public static void waitForLogStatement(String message, K3sContainer k3sContainer, String appLabelValue) {
        try {
            Awaitility.await().atMost(Duration.ofMinutes(2L)).pollInterval(Duration.ofSeconds(4L)).until(() -> {
                String appPodName = k3sContainer.execInContainer(new String[]{"sh", "-c", "kubectl get pods -l app=" + appLabelValue + " -o custom-columns=POD:metadata.name,STATUS:status.phase | grep -i 'running' | awk '{print $1}' | tr -d '\n' "}).getStdout();
                String execResult = k3sContainer.execInContainer(new String[]{"sh", "-c", "kubectl logs " + appPodName.trim()}).getStdout();
                return execResult.contains(message);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class FixedPortsK3sContainer
    extends K3sContainer {
        private FixedPortsK3sContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
        }

        private FixedPortsK3sContainer configureFixedPorts(int[] ports) {
            for (int port : ports) {
                super.addFixedExposedPort(port, port);
            }
            return this;
        }
    }
}

