/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.integration.tests.commons.native_client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1NamespaceBuilder;
import io.kubernetes.client.openapi.models.V1NamespaceFluent;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.Yaml;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.springframework.cloud.kubernetes.integration.tests.commons.Commons;
import org.springframework.cloud.kubernetes.integration.tests.commons.Phase;
import org.testcontainers.k3s.K3sContainer;

public final class Util {
    private static final Log LOG = LogFactory.getLog(Util.class);
    private final CoreV1Api coreV1Api;
    private final AppsV1Api appsV1Api;
    private final NetworkingV1Api networkingV1Api;
    private final RbacAuthorizationV1Api rbacApi;
    private final K3sContainer container;

    public Util(K3sContainer container) {
        ApiClient client;
        try {
            client = Config.fromConfig((Reader)new StringReader(container.getKubeConfigYaml()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        client.setHttpClient(client.getHttpClient().newBuilder().readTimeout(Duration.ofSeconds(15L)).build());
        client.setDebugging(false);
        Configuration.setDefaultApiClient((ApiClient)client);
        this.container = container;
        this.coreV1Api = new CoreV1Api();
        this.appsV1Api = new AppsV1Api();
        this.networkingV1Api = new NetworkingV1Api();
        this.rbacApi = new RbacAuthorizationV1Api();
    }

    public void createAndWait(String namespace, String name, V1Deployment deployment, V1Service service, @Nullable V1Ingress ingress, boolean changeVersion) {
        try {
            String imageFromDeployment = ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
            if (changeVersion) {
                ((V1Container)deployment.getSpec().getTemplate().getSpec().getContainers().get(0)).setImage(imageFromDeployment + ":" + Commons.pomVersion());
            } else {
                String[] image = imageFromDeployment.split(":", 2);
                Commons.pullImage(image[0], image[1], this.container);
                Commons.loadImage(image[0], image[1], name, this.container);
            }
            this.appsV1Api.createNamespacedDeployment(namespace, deployment, null, null, null, null);
            this.coreV1Api.createNamespacedService(namespace, service, null, null, null, null);
            this.waitForDeployment(namespace, deployment);
            if (ingress != null) {
                this.networkingV1Api.createNamespacedIngress(namespace, ingress, null, null, null, null);
                this.waitForIngress(namespace, ingress);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createAndWait(String namespace, @Nullable V1ConfigMap configMap, @Nullable V1Secret secret) {
        try {
            if (configMap != null) {
                this.coreV1Api.createNamespacedConfigMap(namespace, configMap, null, null, null, null);
                this.waitForConfigMap(namespace, configMap, Phase.CREATE);
            }
            if (secret != null) {
                this.coreV1Api.createNamespacedSecret(namespace, secret, null, null, null, null);
                this.waitForSecret(namespace, secret, Phase.CREATE);
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAndWait(String namespace, @Nullable V1ConfigMap configMap, @Nullable V1Secret secret) {
        try {
            if (configMap != null) {
                String configMapName = this.configMapName(configMap);
                this.coreV1Api.deleteNamespacedConfigMap(configMapName, namespace, null, null, null, null, null, null);
                this.waitForConfigMap(namespace, configMap, Phase.DELETE);
            }
            if (secret != null) {
                String secretName = this.secretName(secret);
                this.coreV1Api.deleteNamespacedSecret(secretName, namespace, null, null, null, null, null, null);
                this.waitForSecret(namespace, secret, Phase.DELETE);
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void createNamespace(String name) {
        try {
            this.coreV1Api.createNamespace(((V1NamespaceBuilder)((V1NamespaceFluent.MetadataNested)new V1NamespaceBuilder().withNewMetadata().withName(name)).and()).build(), null, null, null, null);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteAndWait(String namespace, V1Deployment deployment, V1Service service, @Nullable V1Ingress ingress) {
        String deploymentName = this.deploymentName(deployment);
        String serviceName = this.serviceName(service);
        try {
            Map podLabels = this.appsV1Api.readNamespacedDeployment(deploymentName, namespace, null).getSpec().getTemplate().getMetadata().getLabels();
            this.appsV1Api.deleteNamespacedDeployment(deploymentName, namespace, null, null, null, null, null, null);
            this.coreV1Api.deleteNamespacedService(serviceName, namespace, null, null, null, null, null, null);
            this.coreV1Api.deleteCollectionNamespacedPod(namespace, null, null, null, null, null, Util.labelSelector(podLabels), null, null, null, null, null, null, null);
            this.waitForDeploymentToBeDeleted(deploymentName, namespace);
            this.waitForDeploymentPodsToBeDeleted(podLabels, namespace);
            if (ingress != null) {
                String ingressName = this.ingressName(ingress);
                this.networkingV1Api.deleteNamespacedIngress(ingressName, namespace, null, null, null, null, null, null);
                this.waitForIngressToBeDeleted(ingressName, namespace);
            }
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void busybox(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("busybox/deployment.yaml");
        V1Service service = (V1Service)this.yaml("busybox/service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "busybox", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public void kafka(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("kafka/kafka-deployment.yaml");
        V1Service service = (V1Service)this.yaml("kafka/kafka-service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "kafka", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public void rabbitMq(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("rabbitmq/rabbitmq-deployment.yaml");
        V1Service service = (V1Service)this.yaml("rabbitmq/rabbitmq-service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "rabbitmq", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public void zookeeper(String namespace, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("zookeeper/zookeeper-deployment.yaml");
        V1Service service = (V1Service)this.yaml("zookeeper/zookeeper-service.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            this.createAndWait(namespace, "zookeeper", deployment, service, null, false);
        } else if (phase.equals((Object)Phase.DELETE)) {
            this.deleteAndWait(namespace, deployment, service, null);
        }
    }

    public Object yaml(String fileName) {
        ClassLoader classLoader = Util.class.getClassLoader();
        String file = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(fileName))).lines().collect(Collectors.joining("\n"));
        try {
            return Yaml.load((String)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUp(String namespace) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("setup/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), namespace, null);
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(namespace, serviceAccount, null, null, null, null);
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("setup/role-binding.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding, null, null, null, null));
            V1Role role = (V1Role)this.yaml("setup/role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readNamespacedRole(role.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRole(namespace, role, null, null, null, null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setUpClusterWide(String serviceAccountNamespace, Set<String> namespaces) {
        try {
            V1ServiceAccount serviceAccount = (V1ServiceAccount)this.yaml("cluster/service-account.yaml");
            CheckedSupplier<V1ServiceAccount> accountSupplier = () -> this.coreV1Api.readNamespacedServiceAccount(serviceAccount.getMetadata().getName(), serviceAccountNamespace, null);
            CheckedSupplier<V1ServiceAccount> accountDefaulter = () -> this.coreV1Api.createNamespacedServiceAccount(serviceAccountNamespace, serviceAccount, null, null, null, null);
            Util.notExistsHandler(accountSupplier, accountDefaulter);
            V1ClusterRole clusterRole = (V1ClusterRole)this.yaml("cluster/cluster-role.yaml");
            Util.notExistsHandler(() -> this.rbacApi.readClusterRole(clusterRole.getMetadata().getName(), null), () -> this.rbacApi.createClusterRole(clusterRole, null, null, null, null));
            V1RoleBinding roleBinding = (V1RoleBinding)this.yaml("cluster/role-binding.yaml");
            namespaces.forEach(namespace -> {
                roleBinding.getMetadata().setNamespace(namespace);
                try {
                    Util.notExistsHandler(() -> this.rbacApi.readNamespacedRoleBinding(roleBinding.getMetadata().getName(), namespace, null), () -> this.rbacApi.createNamespacedRoleBinding(namespace, roleBinding, null, null, null, null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteNamespace(String name) {
        try {
            this.coreV1Api.deleteNamespace(name, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(30L, TimeUnit.SECONDS).until(() -> this.coreV1Api.listNamespace(null, null, null, null, null, null, null, null, null, null).getItems().stream().noneMatch(x -> x.getMetadata().getName().equals(name)));
    }

    public void wiremock(String namespace, String path, Phase phase) {
        V1Deployment deployment = (V1Deployment)this.yaml("wiremock/wiremock-deployment.yaml");
        V1Service service = (V1Service)this.yaml("wiremock/wiremock-service.yaml");
        V1Ingress ingress = (V1Ingress)this.yaml("wiremock/wiremock-ingress.yaml");
        if (phase.equals((Object)Phase.CREATE)) {
            deployment.getMetadata().setNamespace(namespace);
            service.getMetadata().setNamespace(namespace);
            ingress.getMetadata().setNamespace(namespace);
            ((V1HTTPIngressPath)((V1IngressRule)ingress.getSpec().getRules().get(0)).getHttp().getPaths().get(0)).setPath(path);
            this.createAndWait(namespace, "wiremock", deployment, service, ingress, false);
        } else {
            this.deleteAndWait(namespace, deployment, service, ingress);
        }
    }

    private String deploymentName(V1Deployment deployment) {
        return deployment.getMetadata().getName();
    }

    private String serviceName(V1Service service) {
        return service.getMetadata().getName();
    }

    private String ingressName(V1Ingress ingress) {
        return ingress.getMetadata().getName();
    }

    private String configMapName(V1ConfigMap configMap) {
        return configMap.getMetadata().getName();
    }

    private String secretName(V1Secret secret) {
        return secret.getMetadata().getName();
    }

    private void waitForDeployment(String namespace, V1Deployment deployment) {
        String deploymentName = this.deploymentName(deployment);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> this.isDeploymentReady(deploymentName, namespace));
    }

    private void waitForConfigMap(String namespace, V1ConfigMap configMap, Phase phase) {
        String configMapName = this.configMapName(configMap);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            try {
                this.coreV1Api.readNamespacedConfigMap(configMapName, namespace, null);
                return phase.equals((Object)Phase.CREATE);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return !phase.equals((Object)Phase.CREATE);
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForSecret(String namespace, V1Secret secret, Phase phase) {
        String secretName = this.secretName(secret);
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).atMost(600L, TimeUnit.SECONDS).until(() -> {
            try {
                this.coreV1Api.readNamespacedSecret(secretName, namespace, null);
                return phase.equals((Object)Phase.CREATE);
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return !phase.equals((Object)Phase.CREATE);
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForIngress(String namespace, V1Ingress ingress) {
        String ingressName = this.ingressName(ingress);
        Awaitility.await().timeout(Duration.ofSeconds(90L)).pollInterval(Duration.ofSeconds(3L)).until(() -> {
            try {
                V1LoadBalancerStatus status = this.networkingV1Api.readNamespacedIngress(ingressName, namespace, null).getStatus().getLoadBalancer();
                if (status == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer not yet present)"));
                    return false;
                }
                List loadBalancerIngress = status.getIngress();
                if (loadBalancerIngress == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet (loadbalancer ingress not yet present)"));
                    return false;
                }
                String ip = ((V1LoadBalancerIngress)loadBalancerIngress.get(0)).getIp();
                if (ip == null) {
                    LOG.info((Object)("ingress : " + ingressName + " not ready yet"));
                    return false;
                }
                LOG.info((Object)("ingress : " + ingressName + " ready with ip : " + ip));
                return true;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return false;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForDeploymentToBeDeleted(String deploymentName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).until(() -> {
            try {
                this.appsV1Api.readNamespacedDeployment(deploymentName, namespace, null);
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForDeploymentPodsToBeDeleted(Map<String, String> labels, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).until(() -> {
            try {
                int currentNumberOfPods = this.coreV1Api.listNamespacedPod(namespace, null, null, null, null, Util.labelSelector(labels), null, null, null, null, null).getItems().size();
                return currentNumberOfPods == 0;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private void waitForIngressToBeDeleted(String ingressName, String namespace) {
        Awaitility.await().timeout(Duration.ofSeconds(90L)).until(() -> {
            try {
                this.networkingV1Api.readNamespacedIngress(ingressName, namespace, null);
                return false;
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    return true;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private boolean isDeploymentReady(String deploymentName, String namespace) throws ApiException {
        V1Deployment deployment;
        Integer availableReplicas;
        V1DeploymentList deployments = this.appsV1Api.listNamespacedDeployment(namespace, null, null, null, "metadata.name=" + deploymentName, null, null, null, null, null, null);
        if (deployments.getItems().size() < 1) {
            Assert.fail((String)("No deployments with the name " + deploymentName));
        }
        LOG.info((Object)("Available replicas for " + deploymentName + ": " + ((availableReplicas = (deployment = (V1Deployment)deployments.getItems().get(0)).getStatus().getAvailableReplicas()) == null ? 0 : availableReplicas)));
        return availableReplicas != null && availableReplicas >= 1;
    }

    private static <T> void notExistsHandler(CheckedSupplier<T> callee, CheckedSupplier<T> defaulter) throws Exception {
        try {
            callee.get();
        }
        catch (Exception exception) {
            ApiException apiException;
            if (exception instanceof ApiException && (apiException = (ApiException)((Object)exception)).getCode() == 404) {
                defaulter.get();
                return;
            }
            throw new RuntimeException(exception);
        }
    }

    private static String labelSelector(Map<String, String> labels) {
        return labels.entrySet().stream().map(en -> (String)en.getKey() + "=" + (String)en.getValue()).collect(Collectors.joining(","));
    }

    private static interface CheckedSupplier<T> {
        public T get() throws Exception;
    }
}

