/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.ribbon;

import com.netflix.loadbalancer.Server;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.ribbon.KubernetesRibbonProperties;
import org.springframework.cloud.kubernetes.ribbon.KubernetesServerList;

public class KubernetesServicesServerList
extends KubernetesServerList {
    private static final Log LOG = LogFactory.getLog(KubernetesServicesServerList.class);

    KubernetesServicesServerList(KubernetesClient client, KubernetesRibbonProperties properties) {
        super(client, properties);
    }

    private String concatServiceFQDN(Service service) {
        return String.format("%s.%s.svc.%s", service.getMetadata().getName(), StringUtils.isNotBlank((String)service.getMetadata().getNamespace()) ? service.getMetadata().getNamespace() : "default", this.getProperties().getClusterDomain());
    }

    public List<Server> getUpdatedListOfServers() {
        Service service;
        ArrayList<Server> result = new ArrayList<Server>();
        Service service2 = service = StringUtils.isNotBlank((String)this.getNamespace()) ? (Service)((ServiceResource)((NonNamespaceOperation)this.getClient().services().inNamespace(this.getNamespace())).withName(this.getServiceId())).get() : (Service)((ServiceResource)this.getClient().services().withName(this.getServiceId())).get();
        if (service != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found Service[" + service.getMetadata().getName() + "]"));
            }
            if (service.getSpec().getPorts().size() == 1) {
                result.add(new Server(this.concatServiceFQDN(service), ((ServicePort)service.getSpec().getPorts().get(0)).getPort().intValue()));
            } else {
                for (ServicePort servicePort : service.getSpec().getPorts()) {
                    if (!Utils.isNotNullOrEmpty((String)this.getPortName()) && !this.getPortName().endsWith(servicePort.getName())) continue;
                    result.add(new Server(this.concatServiceFQDN(service), servicePort.getPort().intValue()));
                }
            }
        }
        if (result.isEmpty()) {
            LOG.warn((Object)String.format("Did not find any service in ribbon in namespace [%s] for name [%s] and portName [%s]", this.getNamespace(), this.getServiceId(), this.getPortName()));
        }
        return result;
    }
}

