/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.leader;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.kubernetes.leader.LeaderProperties;
import org.springframework.cloud.kubernetes.leader.LeadershipController;

public class LeaderRecordWatcher
implements Watcher<ConfigMap> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderRecordWatcher.class);
    private final Object lock = new Object();
    private final LeadershipController leadershipController;
    private final LeaderProperties leaderProperties;
    private final KubernetesClient kubernetesClient;
    private Watch watch;

    public LeaderRecordWatcher(LeaderProperties leaderProperties, LeadershipController leadershipController, KubernetesClient kubernetesClient) {
        this.leadershipController = leadershipController;
        this.leaderProperties = leaderProperties;
        this.kubernetesClient = kubernetesClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.watch == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.watch == null) {
                    LOGGER.debug("Starting leader record watcher");
                    this.watch = (Watch)((Resource)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(this.leaderProperties.getNamespace(this.kubernetesClient.getNamespace()))).withName(this.leaderProperties.getConfigMapName())).watch((Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.watch != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.watch != null) {
                    LOGGER.debug("Stopping leader record watcher");
                    this.watch.close();
                    this.watch = null;
                }
            }
        }
    }

    public void eventReceived(Watcher.Action action, ConfigMap configMap) {
        LOGGER.debug("'{}' event received, triggering leadership update", (Object)action);
        if (!Watcher.Action.ERROR.equals((Object)action)) {
            this.leadershipController.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(KubernetesClientException cause) {
        if (cause != null) {
            Object object = this.lock;
            synchronized (object) {
                LOGGER.warn("Watcher stopped unexpectedly, will restart", (Throwable)cause);
                this.watch = null;
                this.start();
            }
        }
    }
}

