/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.loadbalancer;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesLoadBalancerProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;

public class Fabric8ServiceInstanceMapper
implements KubernetesServiceInstanceMapper<Service> {
    private static final Map<String, Integer> PORTS_DATA = Map.of();
    private final KubernetesLoadBalancerProperties properties;
    private final KubernetesDiscoveryProperties discoveryProperties;

    Fabric8ServiceInstanceMapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        this.properties = properties;
        this.discoveryProperties = discoveryProperties;
    }

    public KubernetesServiceInstance map(Service service) {
        Optional<ServicePort> optPort;
        ObjectMeta meta = service.getMetadata();
        List ports = service.getSpec().getPorts();
        ServicePort port = null;
        if (ports.size() == 1) {
            port = (ServicePort)ports.get(0);
        } else if (ports.size() > 1 && Utils.isNotNullOrEmpty((String)this.properties.getPortName()) && (optPort = ports.stream().filter(it -> this.properties.getPortName().endsWith(it.getName())).findAny()).isPresent()) {
            port = optPort.get();
        }
        if (port == null) {
            return null;
        }
        String host = KubernetesServiceInstanceMapper.createHost((String)service.getMetadata().getName(), (String)service.getMetadata().getNamespace(), (String)this.properties.getClusterDomain());
        boolean secure = KubernetesServiceInstanceMapper.isSecure((Map)service.getMetadata().getLabels(), (Map)service.getMetadata().getAnnotations(), (String)port.getName(), (Integer)port.getPort());
        return new DefaultKubernetesServiceInstance(meta.getUid(), meta.getName(), host, port.getPort().intValue(), this.serviceMetadata(service), secure);
    }

    Map<String, String> serviceMetadata(Service service) {
        ServiceMetadata serviceMetadata = Fabric8Utils.serviceMetadata((Service)service);
        return DiscoveryClientUtils.serviceInstanceMetadata(PORTS_DATA, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.discoveryProperties);
    }
}

