/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader.election;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BooleanSupplier;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionInitiatorUtil;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.cloud.kubernetes.commons.leader.election.PodReadyRunner;
import org.springframework.core.log.LogAccessor;

final class Fabric8LeaderElectionInitiator {
    private static final LogAccessor LOG = new LogAccessor(Fabric8LeaderElectionInitiator.class);
    private final PodReadyRunner podReadyRunner;
    private final String candidateIdentity;
    private final KubernetesClient fabric8KubernetesClient;
    private final LeaderElectionConfig leaderElectionConfig;
    private final LeaderElectionProperties leaderElectionProperties;
    private final boolean waitForPodReady;
    private final ExecutorService podReadyWaitingExecutor;
    private final BooleanSupplier podReadySupplier;
    private volatile CompletableFuture<Void> podReadyFuture;
    private volatile CompletableFuture<?> leaderFuture;

    Fabric8LeaderElectionInitiator(String candidateIdentity, String candidateNamespace, KubernetesClient fabric8KubernetesClient, LeaderElectionConfig leaderElectionConfig, LeaderElectionProperties leaderElectionProperties, BooleanSupplier podReadySupplier) {
        this.candidateIdentity = candidateIdentity;
        this.fabric8KubernetesClient = fabric8KubernetesClient;
        this.leaderElectionConfig = leaderElectionConfig;
        this.leaderElectionProperties = leaderElectionProperties;
        this.waitForPodReady = leaderElectionProperties.waitForPodReady();
        this.podReadySupplier = podReadySupplier;
        this.podReadyWaitingExecutor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "Fabric8LeaderElectionInitiator-" + candidateIdentity));
        this.podReadyRunner = new PodReadyRunner(candidateIdentity, candidateNamespace);
    }

    @PostConstruct
    void postConstruct() {
        LOG.info(() -> "starting leader initiator : " + this.candidateIdentity);
        if (this.waitForPodReady) {
            LOG.info(() -> "will wait until pod " + this.candidateIdentity + " is ready");
            this.podReadyFuture = this.podReadyRunner.podReady(this.podReadySupplier);
        } else {
            this.podReadyFuture = CompletableFuture.completedFuture(null);
        }
        this.podReadyWaitingExecutor.execute(() -> {
            try {
                if (this.waitForPodReady) {
                    CompletableFuture ready = LeaderElectionInitiatorUtil.attachReadinessLoggerPipeline(this.podReadyFuture, (String)this.candidateIdentity);
                    LeaderElectionInitiatorUtil.blockReadinessCheck((CompletableFuture)ready);
                    this.startLeaderElection();
                } else {
                    this.startLeaderElection();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e, () -> "failure : " + e.getMessage());
            }
        });
    }

    @PreDestroy
    void preDestroy() {
        LOG.info(() -> "preDestroy called on the leader initiator : " + this.candidateIdentity);
        if (this.podReadyFuture != null && !this.podReadyFuture.isDone()) {
            LOG.debug(() -> "podReadyFuture will be canceled for : " + this.candidateIdentity);
            this.podReadyFuture.cancel(true);
        }
        if (!this.podReadyWaitingExecutor.isShutdown()) {
            LeaderElectionInitiatorUtil.shutDownExecutor((ExecutorService)this.podReadyWaitingExecutor, (String)this.candidateIdentity);
        }
        if (this.leaderFuture != null) {
            LOG.debug(() -> "leaderFuture will be canceled for : " + this.candidateIdentity);
            this.leaderFuture.cancel(true);
        }
    }

    CompletableFuture<?> leaderFeature() {
        return this.leaderFuture;
    }

    private void startLeaderElection() {
        this.leaderFuture = this.fabric8KubernetesClient.leaderElector().withConfig(this.leaderElectionConfig).build().start();
        this.leaderFuture.whenComplete((ok, error) -> {
            if (error != null) {
                if (error instanceof CancellationException) {
                    LOG.info(() -> "cancel was called on the leader initiator : " + this.candidateIdentity);
                    LOG.info(() -> "terminating leadership for : " + this.candidateIdentity);
                } else {
                    LOG.warn(() -> "leader failed with : " + error.getMessage());
                    if (this.leaderElectionProperties.restartOnFailure()) {
                        LOG.info(() -> "will restart leader election for : " + this.candidateIdentity);
                        LeaderElectionInitiatorUtil.sleep((LeaderElectionProperties)this.leaderElectionProperties);
                        this.podReadyWaitingExecutor.execute(this::startLeaderElection);
                    } else {
                        LOG.warn(() -> "leader election is over for : " + this.candidateIdentity);
                    }
                }
            } else {
                LOG.info(() -> "leaderFuture finished normally, will re-start it for : " + this.candidateIdentity);
                this.podReadyWaitingExecutor.execute(this::startLeaderElection);
            }
        });
        try {
            this.leaderFuture.get();
        }
        catch (Exception e) {
            LOG.warn(() -> "leader election failed for : " + this.candidateIdentity);
        }
    }
}

