/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader.election;

import io.fabric8.kubernetes.api.model.APIResource;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.GroupVersionForDiscovery;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.client.readiness.Readiness;
import java.util.function.BooleanSupplier;
import org.springframework.boot.actuate.autoconfigure.info.ConditionalOnEnabledInfoContributor;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.leader.election.ConditionalOnLeaderElectionEnabled;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.cloud.kubernetes.fabric8.leader.election.Fabric8LeaderElectionCallbacks;
import org.springframework.cloud.kubernetes.fabric8.leader.election.Fabric8LeaderElectionCallbacksAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.leader.election.Fabric8LeaderElectionInfoContributor;
import org.springframework.cloud.kubernetes.fabric8.leader.election.Fabric8LeaderElectionInitiator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LeaderElectionProperties.class})
@ConditionalOnBean(value={KubernetesClient.class})
@ConditionalOnLeaderElectionEnabled
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@AutoConfigureAfter(value={Fabric8LeaderElectionCallbacksAutoConfiguration.class})
class Fabric8LeaderElectionAutoConfiguration {
    private static final String COORDINATION_VERSION_GROUP = "coordination.k8s.io/v1";
    private static final LogAccessor LOG = new LogAccessor(Fabric8LeaderElectionAutoConfiguration.class);

    Fabric8LeaderElectionAutoConfiguration() {
    }

    @Bean
    @ConditionalOnClass(value={InfoContributor.class})
    @ConditionalOnEnabledInfoContributor(value="leader.election")
    Fabric8LeaderElectionInfoContributor fabric8LeaderElectionInfoContributor(String candidateIdentity, LeaderElectionConfig leaderElectionConfig, KubernetesClient fabric8KubernetesClient) {
        return new Fabric8LeaderElectionInfoContributor(candidateIdentity, leaderElectionConfig, fabric8KubernetesClient);
    }

    @Bean
    @ConditionalOnMissingBean
    Fabric8LeaderElectionInitiator fabric8LeaderElectionInitiator(String candidateIdentity, String podNamespace, KubernetesClient fabric8KubernetesClient, LeaderElectionConfig fabric8LeaderElectionConfig, LeaderElectionProperties leaderElectionProperties, BooleanSupplier podReadySupplier) {
        return new Fabric8LeaderElectionInitiator(candidateIdentity, podNamespace, fabric8KubernetesClient, fabric8LeaderElectionConfig, leaderElectionProperties, podReadySupplier);
    }

    @Bean
    BooleanSupplier fabric8PodReadySupplier(KubernetesClient fabric8KubernetesClient, String candidateIdentity, String podNamespace) {
        return () -> {
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)fabric8KubernetesClient.pods().inNamespace(podNamespace)).withName(candidateIdentity)).get();
            return Readiness.isPodReady((Pod)pod);
        };
    }

    @Bean
    @ConditionalOnMissingBean
    LeaderElectionConfig fabric8LeaderElectionConfig(LeaderElectionProperties properties, Lock lock, Fabric8LeaderElectionCallbacks fabric8LeaderElectionCallbacks) {
        return ((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)((LeaderElectionConfigBuilder)new LeaderElectionConfigBuilder().withReleaseOnCancel()).withName("Spring k8s leader election")).withLeaseDuration(properties.leaseDuration())).withLock(lock)).withRenewDeadline(properties.renewDeadline())).withRetryPeriod(properties.retryPeriod())).withLeaderCallbacks((LeaderCallbacks)fabric8LeaderElectionCallbacks)).build();
    }

    @Bean
    @ConditionalOnMissingBean
    Lock fabric8LeaderElectionLock(KubernetesClient fabric8KubernetesClient, LeaderElectionProperties properties, String candidateIdentity) {
        boolean leaseSupported = fabric8KubernetesClient.getApiGroups().getGroups().stream().flatMap(x -> x.getVersions().stream()).map(GroupVersionForDiscovery::getGroupVersion).filter(COORDINATION_VERSION_GROUP::equals).findFirst().map(arg_0 -> ((KubernetesClient)fabric8KubernetesClient).getApiResources(arg_0)).map(APIResourceList::getResources).map(x -> x.stream().map(APIResource::getKind)).flatMap(x -> x.filter(y -> y.equals("Lease")).findFirst()).isPresent();
        if (leaseSupported) {
            if (properties.useConfigMapAsLock()) {
                LOG.info(() -> "leases are supported on the cluster, but config map will be used (because 'spring.cloud.kubernetes.leader.election.use-config-map-as-lock=true')");
                return new ConfigMapLock(properties.lockNamespace(), properties.lockName(), candidateIdentity);
            }
            LOG.info(() -> "will use lease as the lock for leader election");
            return new LeaseLock(properties.lockNamespace(), properties.lockName(), candidateIdentity);
        }
        LOG.info(() -> "will use configmap as the lock for leader election");
        return new ConfigMapLock(properties.lockNamespace(), properties.lockName(), candidateIdentity);
    }
}

