/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.readiness.Readiness;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.leader.LeaderUtils;
import org.springframework.cloud.kubernetes.commons.leader.PodReadinessWatcher;
import org.springframework.cloud.kubernetes.fabric8.leader.Fabric8LeadershipController;
import org.springframework.core.log.LogAccessor;

public class Fabric8PodReadinessWatcher
implements PodReadinessWatcher,
Watcher<Pod> {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(Fabric8PodReadinessWatcher.class));
    private final ReentrantLock lock = new ReentrantLock();
    private final String podName;
    private final KubernetesClient kubernetesClient;
    private final Fabric8LeadershipController fabric8LeadershipController;
    private volatile boolean previousState;
    private volatile Watch watch;

    public Fabric8PodReadinessWatcher(String podName, KubernetesClient kubernetesClient, Fabric8LeadershipController fabric8LeadershipController) {
        this.podName = podName;
        this.kubernetesClient = kubernetesClient;
        this.fabric8LeadershipController = fabric8LeadershipController;
    }

    public void start() {
        if (this.watch == null) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                if (this.watch == null) {
                    LOGGER.debug(() -> "Starting pod readiness watcher for :" + this.podName);
                    PodResource podResource = (PodResource)this.kubernetesClient.pods().withName(this.podName);
                    this.previousState = podResource.isReady();
                    this.watch = podResource.watch((Watcher)this);
                }
            });
        }
    }

    public void stop() {
        if (this.watch != null) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                if (this.watch != null) {
                    LOGGER.debug(() -> "Stopping pod readiness watcher for :" + this.podName);
                    this.watch.close();
                    this.watch = null;
                }
            });
        }
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        boolean currentState = Readiness.isPodReady((Pod)pod);
        if (this.previousState != currentState) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                if (this.previousState != currentState) {
                    LOGGER.debug(() -> "readiness status changed for pod : " + this.podName + " to state: " + currentState + ", triggering leadership update");
                    this.previousState = currentState;
                    this.fabric8LeadershipController.update();
                }
            });
        }
    }

    public void onClose(WatcherException cause) {
        if (cause != null) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                LOGGER.warn(() -> "Watcher stopped unexpectedly, will restart" + cause.getMessage());
                this.watch = null;
                this.start();
            });
        }
    }
}

