/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.kubernetes.commons.leader.PodReadinessWatcher;
import org.springframework.cloud.kubernetes.fabric8.leader.Fabric8LeadershipController;

public class Fabric8PodReadinessWatcher
implements PodReadinessWatcher,
Watcher<Pod> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fabric8PodReadinessWatcher.class);
    private final Object lock = new Object();
    private final String podName;
    private final KubernetesClient kubernetesClient;
    private final Fabric8LeadershipController fabric8LeadershipController;
    private boolean previousState;
    private Watch watch;

    public Fabric8PodReadinessWatcher(String podName, KubernetesClient kubernetesClient, Fabric8LeadershipController fabric8LeadershipController) {
        this.podName = podName;
        this.kubernetesClient = kubernetesClient;
        this.fabric8LeadershipController = fabric8LeadershipController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.watch == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.watch == null) {
                    LOGGER.debug("Starting pod readiness watcher for '{}'", (Object)this.podName);
                    PodResource podResource = (PodResource)this.kubernetesClient.pods().withName(this.podName);
                    this.previousState = podResource.isReady();
                    this.watch = podResource.watch((Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.watch != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.watch != null) {
                    LOGGER.debug("Stopping pod readiness watcher for '{}'", (Object)this.podName);
                    this.watch.close();
                    this.watch = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventReceived(Watcher.Action action, Pod pod) {
        boolean currentState = Readiness.isPodReady((Pod)pod);
        if (this.previousState != currentState) {
            Object object = this.lock;
            synchronized (object) {
                if (this.previousState != currentState) {
                    LOGGER.debug("'{}' readiness status changed to '{}', triggering leadership update", (Object)this.podName, (Object)currentState);
                    this.previousState = currentState;
                    this.fabric8LeadershipController.update();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(WatcherException cause) {
        if (cause != null) {
            Object object = this.lock;
            synchronized (object) {
                LOGGER.warn("Watcher stopped unexpectedly, will restart", (Throwable)cause);
                this.watch = null;
                this.start();
            }
        }
    }
}

