/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

abstract class Fabric8AbstractReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final Fabric8DiscoveryClient fabric8DiscoveryClient;

    Fabric8AbstractReactiveDiscoveryClient(Fabric8DiscoveryClient fabric8DiscoveryClient) {
        this.fabric8DiscoveryClient = fabric8DiscoveryClient;
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> Flux.fromIterable(this.fabric8DiscoveryClient.getServices())).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must not be null");
        return Flux.defer(() -> Flux.fromIterable(this.fabric8DiscoveryClient.getInstances(serviceId))).subscribeOn(Schedulers.boundedElastic());
    }

    public abstract String description();

    public int getOrder() {
        return this.fabric8DiscoveryClient.getOrder();
    }
}

