/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.function.Predicate;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableReactiveDisabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableReactiveEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesReactiveDiscovery;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CacheableReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClientSpelAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8ReactiveDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesReactiveDiscovery
@AutoConfigureBefore(value={SimpleReactiveDiscoveryClientAutoConfiguration.class, ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class, Fabric8DiscoveryClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class, Fabric8DiscoveryClientSpelAutoConfiguration.class})
public final class Fabric8ReactiveDiscoveryClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableReactiveDisabled
    Fabric8ReactiveDiscoveryClient fabric8ReactiveDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, Predicate<Service> predicate, Environment environment) {
        ServicePortSecureResolver servicePortSecureResolver = new ServicePortSecureResolver(properties);
        KubernetesNamespaceProvider namespaceProvider = new KubernetesNamespaceProvider(environment);
        Fabric8DiscoveryClient fabric8DiscoveryClient = new Fabric8DiscoveryClient(client, properties, servicePortSecureResolver, namespaceProvider, predicate);
        return new Fabric8ReactiveDiscoveryClient(fabric8DiscoveryClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableReactiveEnabled
    Fabric8CacheableReactiveDiscoveryClient fabric8CacheableReactiveDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, Predicate<Service> predicate, Environment environment) {
        ServicePortSecureResolver servicePortSecureResolver = new ServicePortSecureResolver(properties);
        KubernetesNamespaceProvider namespaceProvider = new KubernetesNamespaceProvider(environment);
        Fabric8DiscoveryClient blockingClient = new Fabric8DiscoveryClient(client, properties, servicePortSecureResolver, namespaceProvider, predicate);
        return new Fabric8CacheableReactiveDiscoveryClient(blockingClient);
    }
}

