/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.function.Predicate;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableBlockingDisabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableBlockingEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesBlockingDiscovery;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CacheableDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryClientSpelAutoConfiguration;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesBlockingDiscovery
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={Fabric8AutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class, Fabric8DiscoveryClientSpelAutoConfiguration.class, Fabric8DiscoveryClientSpelAutoConfiguration.class})
public final class Fabric8DiscoveryClientAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8DiscoveryClientAutoConfiguration.class));

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableBlockingDisabled
    Fabric8DiscoveryClient fabric8DiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, Predicate<Service> predicate, Environment environment) {
        ServicePortSecureResolver servicePortSecureResolver = new ServicePortSecureResolver(properties);
        KubernetesNamespaceProvider namespaceProvider = new KubernetesNamespaceProvider(environment);
        return new Fabric8DiscoveryClient(client, properties, servicePortSecureResolver, namespaceProvider, predicate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableBlockingEnabled
    Fabric8CacheableDiscoveryClient fabric8CacheableDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, Predicate<Service> predicate, Environment environment) {
        ServicePortSecureResolver servicePortSecureResolver = new ServicePortSecureResolver(properties);
        KubernetesNamespaceProvider namespaceProvider = new KubernetesNamespaceProvider(environment);
        return new Fabric8CacheableDiscoveryClient(client, properties, servicePortSecureResolver, namespaceProvider, predicate);
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer
    KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils<?> podUtils) {
        LOG.debug(() -> "Will publish InstanceRegisteredEvent from blocking implementation");
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }
}

