/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnKubernetesCatalogWatcherEnabled;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CatalogWatch;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesCatalogWatcherEnabled
@AutoConfigureAfter(value={Fabric8AutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class})
public final class Fabric8CatalogWatchAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Fabric8CatalogWatch fabric8CatalogWatch(KubernetesClient client, KubernetesDiscoveryProperties properties, Environment environment, ApplicationEventPublisher publisher) {
        return new Fabric8CatalogWatch(client, properties, new KubernetesNamespaceProvider(environment), publisher);
    }
}

