/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8AbstractBlockingDiscoveryClient;

class Fabric8CacheableDiscoveryClient
extends Fabric8AbstractBlockingDiscoveryClient {
    Fabric8CacheableDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, ServicePortSecureResolver servicePortSecureResolver, KubernetesNamespaceProvider namespaceProvider, Predicate<Service> predicate) {
        super(client, kubernetesDiscoveryProperties, servicePortSecureResolver, namespaceProvider, predicate);
    }

    @Override
    @Cacheable(value={"fabric8-blocking-discovery-services"})
    public List<String> getServices() {
        return super.getServices();
    }

    @Override
    @Cacheable(value={"fabric8-blocking-discovery-instances"})
    public List<ServiceInstance> getInstances(String serviceId) {
        return super.getInstances(serviceId);
    }

    @Override
    public String description() {
        return "Fabric8 Cacheable Blocking Discovery Client";
    }
}

