/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Service;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.cloud.kubernetes.commons.discovery.InstanceIdHostPodName;

final class Fabric8InstanceIdHostPodNameSupplier
implements Supplier<InstanceIdHostPodName> {
    private final EndpointAddress endpointAddress;
    private final Service service;

    private Fabric8InstanceIdHostPodNameSupplier(EndpointAddress endpointAddress, Service service) {
        this.endpointAddress = endpointAddress;
        this.service = service;
    }

    @Override
    public InstanceIdHostPodName get() {
        return new InstanceIdHostPodName(this.instanceId(), this.host(), this.podName());
    }

    static Fabric8InstanceIdHostPodNameSupplier nonExternalName(EndpointAddress endpointAddress, Service service) {
        return new Fabric8InstanceIdHostPodNameSupplier(endpointAddress, service);
    }

    static Fabric8InstanceIdHostPodNameSupplier externalName(Service service) {
        return new Fabric8InstanceIdHostPodNameSupplier(null, service);
    }

    private String instanceId() {
        return Optional.ofNullable(this.endpointAddress).map(EndpointAddress::getTargetRef).map(ObjectReference::getUid).orElseGet(() -> this.service.getMetadata().getUid());
    }

    private String host() {
        return Optional.ofNullable(this.endpointAddress).map(EndpointAddress::getIp).orElseGet(() -> this.service.getSpec().getExternalName());
    }

    private String podName() {
        return Optional.ofNullable(this.endpointAddress).map(EndpointAddress::getTargetRef).filter(objectReference -> "Pod".equals(objectReference.getKind())).map(ObjectReference::getName).orElse(null);
    }
}

