/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8CatalogWatchContext;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8KubernetesDiscoveryClientUtils;

final class Fabric8EndpointsCatalogWatch
implements Function<Fabric8CatalogWatchContext, List<EndpointNameAndNamespace>> {
    Fabric8EndpointsCatalogWatch() {
    }

    @Override
    public List<EndpointNameAndNamespace> apply(Fabric8CatalogWatchContext context) {
        List<Endpoints> endpoints = Fabric8KubernetesDiscoveryClientUtils.endpoints(context.properties(), context.kubernetesClient(), context.namespaceProvider(), "catalog-watcher", null, Fabric8KubernetesDiscoveryClientUtils.ALWAYS_TRUE);
        return this.generateState(endpoints);
    }

    List<EndpointNameAndNamespace> generateState(List<Endpoints> endpoints) {
        Stream<ObjectReference> references = endpoints.stream().map(Endpoints::getSubsets).filter(Objects::nonNull).flatMap(Collection::stream).map(EndpointSubset::getAddresses).filter(Objects::nonNull).flatMap(Collection::stream).map(EndpointAddress::getTargetRef);
        return Fabric8CatalogWatchContext.state(references);
    }
}

