/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.core.log.LogAccessor;

class ServicePortSecureResolver {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ServicePortSecureResolver.class));
    private static final Set<String> TRUTHY_STRINGS = Set.of("true", "on", "yes", "1");
    private final KubernetesDiscoveryProperties properties;

    ServicePortSecureResolver(KubernetesDiscoveryProperties properties) {
        this.properties = properties;
    }

    boolean resolve(Input input) {
        String securedLabelValue = input.serviceLabels().getOrDefault("secured", "false");
        String serviceName = input.serviceName();
        Integer port = input.port();
        if (TRUTHY_STRINGS.contains(securedLabelValue)) {
            ServicePortSecureResolver.logEntry(serviceName, port, "the service contains a true value for the 'secured' label");
            return true;
        }
        String securedAnnotationValue = input.serviceAnnotations().getOrDefault("secured", "false");
        if (TRUTHY_STRINGS.contains(securedAnnotationValue)) {
            ServicePortSecureResolver.logEntry(serviceName, port, "the service contains a true value for the 'secured' annotation");
            return true;
        }
        if (port != null && this.properties.knownSecurePorts().contains(port)) {
            ServicePortSecureResolver.logEntry(serviceName, port, "port is known to be a https port");
            return true;
        }
        return false;
    }

    private static void logEntry(String serviceName, Integer port, String reason) {
        LOG.debug(() -> "Considering service with name: " + serviceName + " and port " + port + " to be secure since " + reason);
    }

    record Input(Integer port, String serviceName, Map<String, String> serviceLabels, Map<String, String> serviceAnnotations) {
        Input(Integer port, String serviceName) {
            this(port, serviceName, null, null);
        }

        Input(Integer port, String serviceName, Map<String, String> serviceLabels, Map<String, String> serviceAnnotations) {
            this.port = port;
            this.serviceName = serviceName;
            this.serviceLabels = serviceLabels == null ? Map.of() : serviceLabels;
            this.serviceAnnotations = serviceAnnotations == null ? Map.of() : serviceAnnotations;
        }
    }
}

