/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

final class Fabric8DiscoveryServicesAdapter
implements Function<KubernetesClient, List<Service>> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final SimpleEvaluationContext EVALUATION_CONTEXT = SimpleEvaluationContext.forReadOnlyDataBinding().withInstanceMethods().build();
    private final KubernetesClientServicesFunction function;
    private final KubernetesDiscoveryProperties properties;
    private final Predicate<Service> filter;

    Fabric8DiscoveryServicesAdapter(KubernetesClientServicesFunction function, KubernetesDiscoveryProperties properties, Predicate<Service> filter) {
        this.function = function;
        this.properties = properties;
        this.filter = filter == null ? this.filter() : filter;
    }

    @Override
    public List<Service> apply(KubernetesClient client) {
        if (!this.properties.namespaces().isEmpty()) {
            ArrayList<Service> services = new ArrayList<Service>();
            this.properties.namespaces().forEach(namespace -> services.addAll(((ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)client.services().inNamespace(namespace)).withLabels(this.properties.serviceLabels())).list()).getItems().stream().filter(this.filter).toList()));
            return services;
        }
        return ((ServiceList)((FilterWatchListDeletable)this.function.apply(client)).list()).getItems().stream().filter(this.filter).toList();
    }

    Predicate<Service> filter() {
        Predicate<Service> predicate;
        String spelExpression = this.properties.filter();
        if (spelExpression == null || spelExpression.isEmpty()) {
            predicate = service -> true;
        } else {
            Expression filterExpr = PARSER.parseExpression(spelExpression);
            predicate = service -> {
                Boolean include = (Boolean)filterExpr.getValue((EvaluationContext)EVALUATION_CONTEXT, service, Boolean.class);
                return Optional.ofNullable(include).orElse(false);
            };
        }
        return predicate;
    }
}

