/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;

class DefaultIsServicePortSecureResolver {
    private static final Log log = LogFactory.getLog(DefaultIsServicePortSecureResolver.class);
    private static final Set<String> TRUTHY_STRINGS = new HashSet<String>(){
        {
            this.add("true");
            this.add("on");
            this.add("yes");
            this.add("1");
        }
    };
    private final KubernetesDiscoveryProperties properties;

    DefaultIsServicePortSecureResolver(KubernetesDiscoveryProperties properties) {
        this.properties = properties;
    }

    boolean resolve(Input input) {
        String securedLabelValue = input.getServiceLabels().getOrDefault("secured", "false");
        if (TRUTHY_STRINGS.contains(securedLabelValue)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Considering service with name: " + input.getServiceName() + " and port " + input.getPort() + " is secure since the service contains a true value for the 'secured' label"));
            }
            return true;
        }
        String securedAnnotationValue = input.getServiceAnnotations().getOrDefault("secured", "false");
        if (TRUTHY_STRINGS.contains(securedAnnotationValue)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Considering service with name: " + input.getServiceName() + " and port " + input.getPort() + " is secure since the service contains a true value for the 'secured' annotation"));
            }
            return true;
        }
        if (input.getPort() != null && this.properties.getKnownSecurePorts().contains(input.getPort())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Considering service with name: " + input.getServiceName() + " and port " + input.getPort() + " is secure due to the port being a known https port"));
            }
            return true;
        }
        return false;
    }

    static class Input {
        private final Integer port;
        private final String serviceName;
        private final Map<String, String> serviceLabels;
        private final Map<String, String> serviceAnnotations;

        Input(Integer port, String serviceName) {
            this(port, serviceName, null, null);
        }

        Input(Integer port, String serviceName, Map<String, String> serviceLabels, Map<String, String> serviceAnnotations) {
            this.port = port;
            this.serviceName = serviceName;
            this.serviceLabels = serviceLabels == null ? new HashMap() : serviceLabels;
            this.serviceAnnotations = serviceAnnotations == null ? new HashMap() : serviceAnnotations;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public Map<String, String> getServiceLabels() {
            return this.serviceLabels;
        }

        public Map<String, String> getServiceAnnotations() {
            return this.serviceAnnotations;
        }

        public Integer getPort() {
            return this.port;
        }
    }
}

