/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import java.util.EnumMap;
import java.util.Optional;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigContext;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ContextToSourceData;
import org.springframework.cloud.kubernetes.fabric8.config.LabeledSecretContextToSourceDataProvider;
import org.springframework.cloud.kubernetes.fabric8.config.NamedSecretContextToSourceDataProvider;

public final class Fabric8SecretsPropertySource
extends SecretsPropertySource {
    private static final EnumMap<NormalizedSourceType, Fabric8ContextToSourceData> STRATEGIES = new EnumMap(NormalizedSourceType.class);

    Fabric8SecretsPropertySource(Fabric8ConfigContext context) {
        super(Fabric8SecretsPropertySource.getSourceData(context));
    }

    private static SourceData getSourceData(Fabric8ConfigContext context) {
        NormalizedSourceType type = context.normalizedSource().type();
        return Optional.ofNullable(STRATEGIES.get(type)).map(x -> (SourceData)x.apply(context)).orElseThrow(() -> new IllegalArgumentException("no strategy found for : " + String.valueOf(type)));
    }

    private static Fabric8ContextToSourceData namedSecret() {
        return new NamedSecretContextToSourceDataProvider().get();
    }

    private static Fabric8ContextToSourceData labeledSecret() {
        return new LabeledSecretContextToSourceDataProvider().get();
    }

    static {
        STRATEGIES.put(NormalizedSourceType.NAMED_SECRET, Fabric8SecretsPropertySource.namedSecret());
        STRATEGIES.put(NormalizedSourceType.LABELED_SECRET, Fabric8SecretsPropertySource.labeledSecret());
    }
}

