/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadUtil;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.log.LogAccessor;

public class Fabric8EventBasedSecretsChangeDetector
extends ConfigurationChangeDetector {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8EventBasedSecretsChangeDetector.class));
    private final Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator;
    private final KubernetesClient kubernetesClient;
    private final List<SharedIndexInformer<Secret>> informers = new ArrayList<SharedIndexInformer<Secret>>();
    private final Set<String> namespaces;
    private final boolean enableReloadFiltering;

    public Fabric8EventBasedSecretsChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, KubernetesNamespaceProvider namespaceProvider) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.kubernetesClient = kubernetesClient;
        this.fabric8SecretsPropertySourceLocator = fabric8SecretsPropertySourceLocator;
        this.enableReloadFiltering = properties.enableReloadFiltering();
        this.namespaces = Fabric8ConfigUtils.namespaces(kubernetesClient, namespaceProvider, properties, "secrets");
    }

    @PreDestroy
    private void shutdown() {
        this.informers.forEach(SharedIndexInformer::close);
        this.kubernetesClient.close();
    }

    @PostConstruct
    private void inform() {
        LOG.info((CharSequence)"Kubernetes event-based secrets change detector activated");
        this.namespaces.forEach(namespace -> {
            SharedIndexInformer informer;
            if (this.enableReloadFiltering) {
                informer = ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).withLabels(Map.of("spring.cloud.kubernetes.config.informer.enabled", "true"))).inform();
                LOG.debug((CharSequence)("added secret informer for namespace : " + namespace + " with enabled filter"));
            } else {
                informer = ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).inform();
                LOG.debug((CharSequence)("added secret informer for namespace : " + namespace));
            }
            informer.addEventHandler((ResourceEventHandler)new SecretInformerAwareEventHandler((SharedIndexInformer<Secret>)informer));
            this.informers.add((SharedIndexInformer<Secret>)informer);
        });
    }

    protected void onEvent(Secret secret) {
        boolean reload = ConfigReloadUtil.reload((String)"secrets", (String)secret.toString(), (PropertySourceLocator)this.fabric8SecretsPropertySourceLocator, (ConfigurableEnvironment)this.environment, Fabric8SecretsPropertySource.class);
        if (reload) {
            this.reloadProperties();
        }
    }

    private final class SecretInformerAwareEventHandler
    implements ResourceEventHandler<Secret> {
        private final SharedIndexInformer<Secret> informer;

        private SecretInformerAwareEventHandler(SharedIndexInformer<Secret> informer) {
            this.informer = informer;
        }

        public void onAdd(Secret secret) {
            LOG.debug((CharSequence)("Secret " + secret.getMetadata().getName() + " was added in namespace " + secret.getMetadata().getNamespace()));
            Fabric8EventBasedSecretsChangeDetector.this.onEvent(secret);
        }

        public void onUpdate(Secret oldSecret, Secret newSecret) {
            LOG.debug((CharSequence)("Secret " + newSecret.getMetadata().getName() + " was updated in namespace " + newSecret.getMetadata().getNamespace()));
            Fabric8EventBasedSecretsChangeDetector.this.onEvent(newSecret);
        }

        public void onDelete(Secret secret, boolean deletedFinalStateUnknown) {
            LOG.debug((CharSequence)("Secret " + secret.getMetadata().getName() + " was deleted in namespace " + secret.getMetadata().getNamespace()));
            Fabric8EventBasedSecretsChangeDetector.this.onEvent(secret);
        }

        public void onNothing() {
            List store = this.informer.getStore().list();
            LOG.info((CharSequence)("onNothing called with a store of size : " + store.size()));
            LOG.info((CharSequence)"this might be an indication of a HTTP_GONE code");
        }
    }
}

