/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.SecretsCache;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigContext;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsCache;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=1)
public class Fabric8SecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private final KubernetesClient client;
    private final KubernetesNamespaceProvider provider;

    Fabric8SecretsPropertySourceLocator(KubernetesClient client, SecretsConfigProperties properties, KubernetesNamespaceProvider provider) {
        super(properties, (SecretsCache)new Fabric8SecretsCache());
        this.client = client;
        this.provider = provider;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, NormalizedSource normalizedSource) {
        String namespace = Fabric8Utils.getApplicationNamespace((KubernetesClient)this.client, (String)normalizedSource.namespace().orElse(null), (String)normalizedSource.target(), (KubernetesNamespaceProvider)this.provider);
        Fabric8ConfigContext context = new Fabric8ConfigContext(this.client, normalizedSource, namespace, (Environment)environment);
        return new Fabric8SecretsPropertySource(context);
    }
}

