/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.core.env.Environment;

public final class Fabric8ConfigUtils {
    private static final Log LOG = LogFactory.getLog(Fabric8ConfigUtils.class);

    private Fabric8ConfigUtils() {
    }

    public static Set<String> namespaces(KubernetesClient client, KubernetesNamespaceProvider provider, ConfigReloadProperties properties, String target) {
        Set<String> namespaces = properties.namespaces();
        if (namespaces.isEmpty()) {
            namespaces = Set.of(Fabric8Utils.getApplicationNamespace((KubernetesClient)client, null, (String)target, (KubernetesNamespaceProvider)provider));
        }
        LOG.debug((Object)("informer namespaces : " + namespaces));
        return namespaces;
    }

    static MultipleSourcesContainer secretsDataByLabels(KubernetesClient client, String namespace, Map<String, String> labels, Environment environment, Set<String> profiles) {
        List<Secret> secrets = Fabric8ConfigUtils.secretsSearch(client, namespace);
        if (ConfigUtils.noSources(secrets, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = Fabric8ConfigUtils.strippedSecrets(secrets);
        return ConfigUtils.processLabeledData(strippedSources, (Environment)environment, labels, (String)namespace, profiles, (boolean)true);
    }

    static MultipleSourcesContainer configMapsDataByLabels(KubernetesClient client, String namespace, Map<String, String> labels, Environment environment, Set<String> profiles) {
        List<ConfigMap> configMaps = Fabric8ConfigUtils.configMapsSearch(client, namespace);
        if (ConfigUtils.noSources(configMaps, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = Fabric8ConfigUtils.strippedConfigMaps(configMaps);
        return ConfigUtils.processLabeledData(strippedSources, (Environment)environment, labels, (String)namespace, profiles, (boolean)false);
    }

    static MultipleSourcesContainer secretsDataByName(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames, Environment environment) {
        List<Secret> secrets = Fabric8ConfigUtils.secretsSearch(client, namespace);
        if (ConfigUtils.noSources(secrets, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = Fabric8ConfigUtils.strippedSecrets(secrets);
        return ConfigUtils.processNamedData(strippedSources, (Environment)environment, sourceNames, (String)namespace, (boolean)true);
    }

    static MultipleSourcesContainer configMapsDataByName(KubernetesClient client, String namespace, LinkedHashSet<String> sourceNames, Environment environment) {
        List<ConfigMap> configMaps = Fabric8ConfigUtils.configMapsSearch(client, namespace);
        if (ConfigUtils.noSources(configMaps, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = Fabric8ConfigUtils.strippedConfigMaps(configMaps);
        return ConfigUtils.processNamedData(strippedSources, (Environment)environment, sourceNames, (String)namespace, (boolean)false);
    }

    private static List<Secret> secretsSearch(KubernetesClient client, String namespace) {
        LOG.debug((Object)("Loading all secrets in namespace '" + namespace + "'"));
        return ((SecretList)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).list()).getItems();
    }

    private static List<ConfigMap> configMapsSearch(KubernetesClient client, String namespace) {
        LOG.debug((Object)("Loading all config maps in namespace '" + namespace + "'"));
        return ((ConfigMapList)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).list()).getItems();
    }

    private static List<StrippedSourceContainer> strippedSecrets(List<Secret> secrets) {
        return secrets.stream().map(secret -> new StrippedSourceContainer(secret.getMetadata().getLabels(), secret.getMetadata().getName(), secret.getData())).collect(Collectors.toList());
    }

    private static List<StrippedSourceContainer> strippedConfigMaps(List<ConfigMap> configMaps) {
        return configMaps.stream().map(configMap -> new StrippedSourceContainer(configMap.getMetadata().getLabels(), configMap.getMetadata().getName(), configMap.getData())).collect(Collectors.toList());
    }
}

