/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=1)
public class Fabric8SecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private final KubernetesClient client;
    private final KubernetesNamespaceProvider provider;

    @Deprecated
    public Fabric8SecretsPropertySourceLocator(KubernetesClient client, SecretsConfigProperties properties) {
        super(properties);
        this.client = client;
        this.provider = null;
    }

    public Fabric8SecretsPropertySourceLocator(KubernetesClient client, SecretsConfigProperties properties, KubernetesNamespaceProvider provider) {
        super(properties);
        this.client = client;
        this.provider = provider;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, SecretsConfigProperties.NormalizedSource normalizedSource, String configurationTarget) {
        String secretName = ConfigUtils.getApplicationName((Environment)environment, (String)normalizedSource.getName(), (String)configurationTarget);
        String secretNamespace = Fabric8ConfigUtils.getApplicationNamespace(this.client, normalizedSource.getNamespace(), configurationTarget, this.provider);
        Map labels = normalizedSource.getLabels();
        return new Fabric8SecretsPropertySource(this.client, secretName, secretNamespace, labels);
    }
}

