/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigUtils;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=1)
public class Fabric8SecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private final KubernetesClient client;

    public Fabric8SecretsPropertySourceLocator(KubernetesClient client, SecretsConfigProperties properties) {
        super(properties);
        this.client = client;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, SecretsConfigProperties.NormalizedSource normalizedSource, String configurationTarget) {
        return new Fabric8SecretsPropertySource(this.client, (Environment)environment, ConfigUtils.getApplicationName((Environment)environment, (String)normalizedSource.getName(), (String)configurationTarget), Fabric8ConfigUtils.getApplicationNamespace(this.client, normalizedSource.getNamespace(), configurationTarget), normalizedSource.getLabels());
    }
}

