/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import jakarta.annotation.Nullable;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.NamespaceResolutionFailedException;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.StringUtils;

public final class Fabric8Utils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8Utils.class));

    private Fabric8Utils() {
    }

    public static ServiceMetadata serviceMetadata(Service service) {
        ObjectMeta metadata = service.getMetadata();
        ServiceSpec serviceSpec = service.getSpec();
        return new ServiceMetadata(metadata.getName(), metadata.getNamespace(), serviceSpec.getType(), metadata.getLabels(), metadata.getAnnotations());
    }

    public static String getApplicationNamespace(KubernetesClient client, @Nullable String namespace, String configurationTarget, KubernetesNamespaceProvider provider) {
        String providerNamespace;
        if (StringUtils.hasText((String)namespace)) {
            LOG.debug(() -> configurationTarget + " namespace : " + namespace);
            return namespace;
        }
        if (provider != null && StringUtils.hasText((String)(providerNamespace = provider.getNamespace()))) {
            LOG.debug(() -> configurationTarget + " namespace from provider : " + providerNamespace);
            return providerNamespace;
        }
        String clientNamespace = client.getNamespace();
        LOG.debug(() -> configurationTarget + " namespace from client : " + clientNamespace);
        if (clientNamespace == null) {
            throw new NamespaceResolutionFailedException("unresolved namespace");
        }
        return clientNamespace;
    }
}

