/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.Service;
import org.springframework.cloud.kubernetes.discovery.DiscoveryServerUrlInvalidException;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

abstract class KubernetesAbstractReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final WebClient webClient;

    KubernetesAbstractReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryProperties properties) {
        if (!StringUtils.hasText((String)properties.discoveryServerUrl())) {
            throw new DiscoveryServerUrlInvalidException();
        }
        this.webClient = webClientBuilder.baseUrl(properties.discoveryServerUrl()).build();
    }

    public Flux<String> getServices() {
        return this.webClient.get().uri("/apps", new Object[0]).exchangeToFlux(clientResponse -> clientResponse.bodyToFlux(Service.class).map(Service::name));
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return this.webClient.get().uri("/apps/" + serviceId, new Object[0]).exchangeToFlux(clientResponse -> clientResponse.bodyToFlux(DefaultKubernetesServiceInstance.class));
    }

    public abstract String description();
}

