/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableReactiveDisabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableReactiveEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesReactiveDiscovery;
import org.springframework.cloud.kubernetes.discovery.KubernetesCacheableReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesReactiveDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesReactiveDiscovery
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class, KubernetesDiscoveryProperties.class})
class KubernetesDiscoveryClientReactiveAutoConfiguration {
    KubernetesDiscoveryClientReactiveAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableReactiveDisabled
    KubernetesReactiveDiscoveryClient kubernetesReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryProperties properties) {
        return new KubernetesReactiveDiscoveryClient(webClientBuilder, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableReactiveEnabled
    KubernetesCacheableReactiveDiscoveryClient kubernetesCacheableReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryProperties properties) {
        return new KubernetesCacheableReactiveDiscoveryClient(webClientBuilder, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    WebClient.Builder webClientBuilder() {
        return WebClient.builder();
    }
}

