/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnHttpDiscoveryCatalogWatcherEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnKubernetesCatalogWatcherEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesCatalogWatch;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesCatalogWatcherEnabled
@ConditionalOnHttpDiscoveryCatalogWatcherEnabled
@EnableConfigurationProperties(value={KubernetesDiscoveryProperties.class})
class KubernetesCatalogWatchAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesCatalogWatchAutoConfiguration.class));

    KubernetesCatalogWatchAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    RestTemplateBuilder restTemplateBuilder() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    KubernetesCatalogWatch kubernetesCatalogWatch(RestTemplateBuilder builder, KubernetesDiscoveryProperties properties, Environment environment) {
        String watchDelay = environment.getProperty("spring.cloud.kubernetes.discovery.catalogServicesWatchDelay");
        if (watchDelay != null) {
            LOG.debug((CharSequence)("using delay : " + watchDelay));
        } else {
            LOG.debug((CharSequence)"using default watch delay : 30000");
        }
        return new KubernetesCatalogWatch(builder, properties);
    }
}

