/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.DiscoveryServerUrlInvalidException;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.discovery.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private RestTemplate rest;
    private KubernetesDiscoveryClientProperties properties;

    public KubernetesDiscoveryClient(RestTemplate rest, KubernetesDiscoveryClientProperties properties) {
        if (!StringUtils.hasText((String)properties.getDiscoveryServerUrl())) {
            throw new DiscoveryServerUrlInvalidException();
        }
        this.rest = rest;
        this.properties = properties;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List<ServiceInstance> response = Collections.emptyList();
        KubernetesServiceInstance[] responseBody = (KubernetesServiceInstance[])this.rest.getForEntity(this.properties.getDiscoveryServerUrl() + "/apps/" + serviceId, KubernetesServiceInstance[].class, new Object[0]).getBody();
        if (responseBody != null && responseBody.length > 0) {
            response = Arrays.asList(responseBody);
        }
        return response;
    }

    public List<String> getServices() {
        List<String> response = Collections.emptyList();
        Service[] services = (Service[])this.rest.getForEntity(this.properties.getDiscoveryServerUrl() + "/apps", Service[].class, new Object[0]).getBody();
        if (services != null && services.length > 0) {
            response = Arrays.stream(services).map(service -> service.getName()).collect(Collectors.toList());
        }
        return response;
    }
}

