/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.common.KubernetesObject;
import org.springframework.cloud.bus.event.PathDestinationFactory;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.ShutdownRemoteApplicationEvent;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.RefreshTrigger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Mono;

final class BusRefreshTrigger
implements RefreshTrigger {
    private final ApplicationEventPublisher applicationEventPublisher;
    private final String busId;
    private final ConfigurationWatcherConfigurationProperties watcherConfigurationProperties;

    BusRefreshTrigger(ApplicationEventPublisher applicationEventPublisher, String busId, ConfigurationWatcherConfigurationProperties watcherConfigurationProperties) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.busId = busId;
        this.watcherConfigurationProperties = watcherConfigurationProperties;
    }

    public Mono<Void> triggerRefresh(KubernetesObject configMap, String appName) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)this.createRefreshApplicationEvent(configMap, appName));
        return Mono.empty();
    }

    private RemoteApplicationEvent createRefreshApplicationEvent(KubernetesObject configMap, String appName) {
        if (this.watcherConfigurationProperties.getRefreshStrategy() == ConfigurationWatcherConfigurationProperties.RefreshStrategy.SHUTDOWN) {
            return new ShutdownRemoteApplicationEvent((Object)configMap, this.busId, new PathDestinationFactory().getDestination(appName));
        }
        return new RefreshRemoteApplicationEvent((Object)configMap, this.busId, new PathDestinationFactory().getDestination(appName));
    }
}

