/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configserver;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.kubernetes.configserver.KubernetesConfigServerEnvironment;
import org.springframework.cloud.kubernetes.configserver.KubernetesConfigServerProperties;
import org.springframework.cloud.kubernetes.configserver.KubernetesPropertySourceSupplier;
import org.springframework.core.Ordered;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

public class KubernetesEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final Log LOG = LogFactory.getLog(KubernetesEnvironmentRepository.class);
    private final CoreV1Api coreApi;
    private final List<KubernetesPropertySourceSupplier> kubernetesPropertySourceSuppliers;
    private final String namespace;
    private final int order;

    public KubernetesEnvironmentRepository(CoreV1Api coreApi, List<KubernetesPropertySourceSupplier> kubernetesPropertySourceSuppliers, String namespace, KubernetesConfigServerProperties properties) {
        this.coreApi = coreApi;
        this.kubernetesPropertySourceSuppliers = kubernetesPropertySourceSuppliers;
        this.namespace = namespace;
        this.order = properties.getOrder();
    }

    public Environment findOne(String application, String profile, String label) {
        return this.findOne(application, profile, label, true);
    }

    public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        if (!StringUtils.hasText((String)profile)) {
            profile = "default";
        }
        ArrayList<String> profiles = new ArrayList<String>(List.of(StringUtils.commaDelimitedListToStringArray((String)profile)));
        Collections.reverse(profiles);
        if (!profiles.contains("default")) {
            profiles.add("default");
        }
        Environment environment = new Environment(application, profiles.toArray(profiles.toArray(new String[0])), label, null, null);
        LOG.info((Object)("Profiles: " + profile));
        LOG.info((Object)("Application: " + application));
        LOG.info((Object)("Label: " + label));
        for (String activeProfile : profiles) {
            try {
                KubernetesConfigServerEnvironment springEnv = new KubernetesConfigServerEnvironment(this.createPropertySources(application));
                springEnv.setActiveProfiles(new String[]{activeProfile});
                if ("application".equalsIgnoreCase(application)) continue;
                this.addApplicationConfiguration(environment, springEnv, application);
            }
            catch (Exception e) {
                LOG.warn((Object)e);
            }
        }
        KubernetesConfigServerEnvironment springEnv = new KubernetesConfigServerEnvironment(this.createPropertySources("application"));
        this.addApplicationConfiguration(environment, springEnv, "application");
        return environment;
    }

    private MutablePropertySources createPropertySources(String application) {
        Map<String, String> applicationProperties = Map.of("spring.application.name", application);
        MapPropertySource propertySource = new MapPropertySource("kubernetes-config-server", applicationProperties);
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        mutablePropertySources.addFirst((PropertySource)propertySource);
        return mutablePropertySources;
    }

    private void addApplicationConfiguration(Environment environment, StandardEnvironment springEnv, String applicationName) {
        this.kubernetesPropertySourceSuppliers.forEach(supplier -> {
            List<MapPropertySource> propertySources = supplier.get(this.coreApi, applicationName, this.namespace, (org.springframework.core.env.Environment)springEnv);
            propertySources.forEach(propertySource -> {
                if (propertySource.getPropertyNames().length > 0) {
                    LOG.debug((Object)("Adding PropertySource " + propertySource.getName()));
                    LOG.debug((Object)("PropertySource Names: " + StringUtils.arrayToCommaDelimitedString((Object[])propertySource.getPropertyNames())));
                    environment.add(new org.springframework.cloud.config.environment.PropertySource(propertySource.getName(), (Map)propertySource.getSource()));
                }
            });
        });
    }

    public int getOrder() {
        return this.order;
    }
}

