/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configserver;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerAutoConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesConfigEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesSecretsEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.configserver.KubernetesConfigServerProperties;
import org.springframework.cloud.kubernetes.configserver.KubernetesEnvironmentRepository;
import org.springframework.cloud.kubernetes.configserver.KubernetesPropertySourceSupplier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class})
@AutoConfigureBefore(value={ConfigServerAutoConfiguration.class})
@ConditionalOnKubernetesEnabled
@EnableConfigurationProperties(value={KubernetesConfigServerProperties.class})
public class KubernetesConfigServerAutoConfiguration {
    @Bean
    @Profile(value={"kubernetes"})
    public EnvironmentRepository kubernetesEnvironmentRepository(CoreV1Api coreV1Api, List<KubernetesPropertySourceSupplier> kubernetesPropertySourceSuppliers, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new KubernetesEnvironmentRepository(coreV1Api, kubernetesPropertySourceSuppliers, kubernetesNamespaceProvider.getNamespace());
    }

    @Bean
    @ConditionalOnKubernetesConfigEnabled
    @ConditionalOnProperty(value={"spring.cloud.kubernetes.config.enableApi"}, matchIfMissing=true)
    public KubernetesPropertySourceSupplier configMapPropertySourceSupplier(KubernetesConfigServerProperties properties) {
        return (coreApi, applicationName, namespace, springEnv) -> {
            List namespaces = KubernetesPropertySourceSupplier.namespaceSplitter((String)properties.getConfigMapNamespaces(), (String)namespace);
            ArrayList propertySources = new ArrayList();
            namespaces.forEach(space -> propertySources.add(new KubernetesClientConfigMapPropertySource(coreApi, applicationName, space, springEnv, "", true, false)));
            return propertySources;
        };
    }

    @Bean
    @ConditionalOnKubernetesSecretsEnabled
    @ConditionalOnProperty(value={"spring.cloud.kubernetes.secrets.enableApi"})
    public KubernetesPropertySourceSupplier secretsPropertySourceSupplier(KubernetesConfigServerProperties properties) {
        return (coreApi, applicationName, namespace, springEnv) -> {
            List namespaces = KubernetesPropertySourceSupplier.namespaceSplitter((String)properties.getSecretsNamespaces(), (String)namespace);
            ArrayList propertySources = new ArrayList();
            namespaces.forEach(space -> propertySources.add(new KubernetesClientSecretsPropertySource(coreApi, applicationName, space, new HashMap(), false)));
            return propertySources;
        };
    }
}

