/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader.election;

import java.net.UnknownHostException;
import java.util.function.Consumer;
import org.springframework.cloud.kubernetes.commons.leader.LeaderUtils;
import org.springframework.cloud.kubernetes.commons.leader.election.LeaderElectionProperties;
import org.springframework.cloud.kubernetes.commons.leader.election.events.NewLeaderEvent;
import org.springframework.cloud.kubernetes.commons.leader.election.events.StartLeadingEvent;
import org.springframework.cloud.kubernetes.commons.leader.election.events.StopLeadingEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.core.log.LogAccessor;

public class LeaderElectionCallbacks {
    private static final LogAccessor LOG = new LogAccessor(LeaderElectionCallbacks.class);

    @Bean
    public final String candidateIdentity() throws UnknownHostException {
        String podHostName = LeaderUtils.hostName();
        LOG.debug(() -> "using pod hostname : " + podHostName);
        return podHostName;
    }

    @Bean
    public final String podNamespace() {
        String podNamespace = LeaderUtils.podNamespace().orElse("default");
        LOG.debug(() -> "using pod namespace : " + podNamespace);
        return podNamespace;
    }

    @Bean
    public final Runnable onStartLeadingCallback(ApplicationEventPublisher applicationEventPublisher, String candidateIdentity, LeaderElectionProperties properties) {
        return () -> {
            LOG.info(() -> candidateIdentity + " is now a leader");
            if (properties.publishEvents()) {
                applicationEventPublisher.publishEvent((ApplicationEvent)new StartLeadingEvent(candidateIdentity));
            }
        };
    }

    @Bean
    public final Runnable onStopLeadingCallback(ApplicationEventPublisher applicationEventPublisher, String candidateIdentity, LeaderElectionProperties properties) {
        return () -> {
            LOG.info(() -> "id : " + candidateIdentity + " stopped being a leader");
            if (properties.publishEvents()) {
                applicationEventPublisher.publishEvent((ApplicationEvent)new StopLeadingEvent(candidateIdentity));
            }
        };
    }

    @Bean
    public final Consumer<String> onNewLeaderCallback(ApplicationEventPublisher applicationEventPublisher, LeaderElectionProperties properties) {
        return candidateIdentity -> {
            LOG.info(() -> "id : " + candidateIdentity + " is the new leader");
            if (properties.publishEvents()) {
                applicationEventPublisher.publishEvent((ApplicationEvent)new NewLeaderEvent(candidateIdentity));
            }
        };
    }
}

