/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.leader.election;

import jakarta.annotation.Nonnull;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogAccessor;

public final class CachedSingleThreadScheduler {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(CachedSingleThreadScheduler.class));
    private final ReentrantLock lock = new ReentrantLock();
    private final long ttlMillis;
    private final String name;
    private ScheduledThreadPoolExecutor executor;

    public CachedSingleThreadScheduler(String name, long ttlMillis) {
        this.ttlMillis = ttlMillis;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        try {
            this.lock.lock();
            this.startExecutor();
            LOG.debug(() -> "Scheduling command to run in : " + this.name);
            ScheduledFuture<?> scheduledFuture = this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            return scheduledFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        try {
            this.lock.lock();
            this.startExecutor();
            LOG.debug(() -> "Scheduling command to run in : " + this.name);
            ScheduledFuture<?> scheduledFuture = this.executor.schedule(command, delay, unit);
            return scheduledFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startExecutor() {
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1, this.threadFactory());
            this.executor.setRemoveOnCancelPolicy(true);
            this.executor.scheduleWithFixedDelay(this::shutdownCheck, this.ttlMillis, this.ttlMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void shutdownCheck() {
        try {
            this.lock.lock();
            if (this.executor.getQueue().isEmpty()) {
                LOG.debug(() -> "Shutting down executor : " + this.name);
                this.executor.shutdownNow();
                this.executor = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private ThreadFactory threadFactory() {
        return new ThreadFactory(){
            final ThreadFactory threadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(@Nonnull Runnable runnable) {
                Thread thread = this.threadFactory.newThread(runnable);
                thread.setName("cached-single-thread-scheduler-" + thread.getName());
                thread.setDaemon(true);
                return thread;
            }
        };
    }
}

