/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.LabeledConfigMapNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.LabeledSecretNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NamedConfigMapNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NamedSecretNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.ReadType;
import org.springframework.cloud.kubernetes.commons.config.RetryProperties;
import org.springframework.cloud.kubernetes.commons.config.SourceType;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SourceConfigProperties {
    private final boolean enabled;
    private final List<Source> sources;
    private final Map<String, String> labels;
    private final String name;
    private final String namespace;
    private final boolean useNameAsPrefix;
    private final boolean includeProfileSpecificSources;
    private final boolean failFast;
    private final RetryProperties retry;
    private final ReadType readType;

    SourceConfigProperties(boolean enabled, List<Source> sources, Map<String, String> labels, String name, String namespace, boolean useNameAsPrefix, boolean includeProfileSpecificSources, boolean failFast, RetryProperties retry, ReadType readType) {
        this.enabled = enabled;
        this.sources = sources;
        this.labels = labels;
        this.name = name;
        this.namespace = namespace;
        this.useNameAsPrefix = useNameAsPrefix;
        this.includeProfileSpecificSources = includeProfileSpecificSources;
        this.failFast = failFast;
        this.retry = retry;
        this.readType = readType;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public List<Source> sources() {
        return this.sources;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public String name() {
        return this.name;
    }

    public String namespace() {
        return this.namespace;
    }

    public boolean useNameAsPrefix() {
        return this.useNameAsPrefix;
    }

    public boolean includeProfileSpecificSources() {
        return this.includeProfileSpecificSources;
    }

    public boolean failFast() {
        return this.failFast;
    }

    public RetryProperties retry() {
        return this.retry;
    }

    public ReadType readType() {
        return this.readType;
    }

    protected final List<NormalizedSource> determineSources(SourceType sourceType, Environment environment) {
        if (this.sources().isEmpty()) {
            ArrayList<NormalizedSource> result = new ArrayList<NormalizedSource>(2);
            String name = ConfigUtils.getApplicationName(environment, this.name(), sourceType.name());
            NormalizedSource normalizedSource = sourceType == SourceType.CONFIGMAP ? new NamedConfigMapNormalizedSource(name, this.namespace(), this.failFast(), this.includeProfileSpecificSources()) : new NamedSecretNormalizedSource(name, this.namespace, this.failFast, this.includeProfileSpecificSources);
            result.add(normalizedSource);
            if (!this.labels().isEmpty()) {
                NormalizedSource labeledSource = sourceType == SourceType.CONFIGMAP ? new LabeledConfigMapNormalizedSource(this.namespace(), this.labels(), this.failFast(), ConfigUtils.Prefix.DEFAULT, false) : new LabeledSecretNormalizedSource(this.namespace, this.labels, this.failFast, ConfigUtils.Prefix.DEFAULT);
                result.add(labeledSource);
            }
            return result;
        }
        return this.sources().stream().flatMap(s -> s.normalize(sourceType, this.name(), this.namespace(), this.labels(), this.includeProfileSpecificSources(), this.failFast(), this.useNameAsPrefix(), environment)).toList();
    }

    public record Source(String name, String namespace, Map<String, String> labels, String explicitPrefix, Boolean useNameAsPrefix, Boolean includeProfileSpecificSources) {
        Stream<NormalizedSource> normalize(SourceType sourceType, String defaultName, String defaultNamespace, Map<String, String> defaultLabels, boolean defaultIncludeProfileSpecificSources, boolean failFast, boolean defaultUseNameAsPrefix, Environment environment) {
            Stream.Builder<NormalizedSource> normalizedSources = Stream.builder();
            String normalizedName = StringUtils.hasLength((String)this.name) ? this.name : defaultName;
            String normalizedNamespace = StringUtils.hasLength((String)this.namespace) ? this.namespace : defaultNamespace;
            Map<String, String> normalizedLabels = this.labels.isEmpty() ? defaultLabels : this.labels;
            String sourceName = ConfigUtils.getApplicationName(environment, normalizedName, sourceType.name());
            ConfigUtils.Prefix prefix = ConfigUtils.findPrefix(this.explicitPrefix, this.useNameAsPrefix, defaultUseNameAsPrefix, normalizedName);
            boolean includeProfileSpecificSources = ConfigUtils.includeProfileSpecificSources(defaultIncludeProfileSpecificSources, this.includeProfileSpecificSources);
            NormalizedSource namedSource = sourceType == SourceType.CONFIGMAP ? new NamedConfigMapNormalizedSource(sourceName, normalizedNamespace, failFast, prefix, includeProfileSpecificSources) : new NamedSecretNormalizedSource(sourceName, normalizedNamespace, failFast, prefix, includeProfileSpecificSources);
            normalizedSources.add(namedSource);
            if (!normalizedLabels.isEmpty()) {
                NormalizedSource labeledSource = sourceType == SourceType.CONFIGMAP ? new LabeledConfigMapNormalizedSource(normalizedNamespace, this.labels, failFast, prefix, includeProfileSpecificSources) : new LabeledSecretNormalizedSource(normalizedNamespace, this.labels, failFast, prefix);
                normalizedSources.add(labeledSource);
            }
            return normalizedSources.build();
        }
    }
}

